import noop from 'lodash/noop';
import { Application, ApplicationEdit, ApplicationForm, Environment, Stage } from '../../../application-list.types';
import { createSlice, PayloadAction } from '@reduxjs/toolkit';

export const initialState: ApplicationForm = {
    stages: [],
    environments: [],
    application: {
        id: '',
        folderId: '',
        title: '',
        environments: [],
    },
    applications: [],
};

export const applicationForm = createSlice({
    name: 'applicationForm',
    initialState,
    reducers: {
        initForm: (_state: ApplicationForm, _action: PayloadAction<ApplicationEdit>) => noop(),
        setApplication: (state: ApplicationForm, action: PayloadAction<Application>) => {
            state.application = action.payload;
        },
        setApplicationFolder: (state: ApplicationForm, action: PayloadAction<string>) => {
            state.application.folderId = action.payload;
        },
        setEnvironments: (state: ApplicationForm, action: PayloadAction<Array<Environment>>) => {
            state.environments = action.payload;
        },
        setStages: (state: ApplicationForm, action: PayloadAction<Array<Stage>>) => {
            state.stages = action.payload;
        },
        setApplications: (state: ApplicationForm, action: PayloadAction<Array<Application>>) => {
            state.applications = action.payload;
        },
        onFormClean: (state: ApplicationForm) => {
            state.application = initialState.application;
        },
        cancelForm: (_state: ApplicationForm, _action: PayloadAction<string>) => noop(),
        onSave: (_state: ApplicationForm, _action: PayloadAction<Application>) => noop(),
        onUpdate: (_state: ApplicationForm, _action: PayloadAction<{ app: Application; folderId: string }>) => noop(),
        pristineFormChange: (_state: ApplicationForm, _action: PayloadAction<boolean>) => noop(),
    },
});
