import React from 'react';
import { StageListHeaderComponent } from './stage-list-header-component';
import { ReactWrapper, preparePortalContainer, mountComponentWithStore } from '@xlr-ui/tests/unit/testing-utils';
import { stages } from '../__mocks__/environment-list.mocks';
import { DotDialog, DotInputText } from '@digital-ai/dot-components';
import { stageState } from '../ducks/stage.reducer';

const { saveStage } = stageState.actions;

describe('Stage list header component', () => {
    let wrapper: ReactWrapper;
    const onFilterChange = jest.fn();
    const dispatch = jest.fn();
    const state = {
        stageState: {
            stageList: stages,
        },
    };

    const mount = () => {
        wrapper = mountComponentWithStore(<StageListHeaderComponent onFilterChange={onFilterChange} />, dispatch, state);
    };

    beforeEach(() => {
        preparePortalContainer();
        mount();
    });

    it('should render with model', () => {
        expect(wrapper).toExist();

        const portal = wrapper.find('ActionToolbarPortal');
        expect(portal.prop('helpLink')).toBe('how-to/using-environments');

        const button = wrapper.find('ActionToolbarPortal button').first();
        expect(button).toExist();
        expect(button.text()).toBe('New stage');
        //trigger popup
        button.simulate('click');
        expect(wrapper.find(DotInputText)).toExist();
    });

    it('should use callbacks', () => {
        const button = wrapper.find('ActionToolbarPortal button').first();
        button.simulate('click');
        const dialog = wrapper.find(DotDialog);
        expect(dialog).toExist();
        const input = dialog.find(DotInputText);
        expect(input).toExist();
        input.invoke('onChange')({ target: { value: 'new' } });
        dialog.invoke('onSubmit')();
        //local state is not changed in tests
        expect(dispatch).toBeCalledWith(saveStage({ id: '', title: '' }));
    });

    it('should validate input', () => {
        const button = wrapper.find('ActionToolbarPortal button').first();
        button.simulate('click');
        const dialog = wrapper.find(DotDialog);
        expect(dialog).toExist();
        const input = dialog.find(DotInputText);
        expect(input).toExist();
        input.invoke('onChange')({ target: { value: 'someStage' } });
        expect(wrapper.find('#stage-title-helper-text')).toExist();
    });

    it('should filter stages', () => {
        const filterInput = wrapper.find(DotInputText).at(0);
        expect(filterInput).toExist();
        filterInput.invoke('onChange')({ target: { value: 'filter' } });
        expect(onFilterChange).toHaveBeenCalledWith('filter');
    });

    it('should close dialog', () => {
        const button = wrapper.find('ActionToolbarPortal button').first();
        button.simulate('click');
        const dialog = wrapper.find(DotDialog);
        expect(dialog).toExist();
        dialog.invoke('onCancel')();
        expect(dialog.prop('title')).toStrictEqual('New stage');
    });
});
