package com.xebialabs.xlrelease.environments.repository.sql.persistence

import org.springframework.util.StringUtils

package object builder {
  def makeAlias(prefix: String, alias: String): String = {
    if (StringUtils.hasText(prefix)) {
      prefix + "_" + alias
    } else {
      alias
    }
  }

  def indent(query: String): String = Predef.augmentString(query).linesIterator.map(line => s"\t$line").mkString("\n")
}
