/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql.persistence;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.LimitOffset;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.domain.id.IdCreator$;
import com.xebialabs.xlrelease.domain.id.package;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.ApplicationPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases$Applications$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases$EnvLabels$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases$EnvReservations$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases$EnvStages$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases$Environments$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.data.EnvironmentReservationRow;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.data.EnvironmentReservationRow$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.ApplicationSchema$APPLICATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentLabelSchema$ENV_LABELS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentReservationSchema$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentReservationSchema$ENV_RESERVATIONS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentReservationSchema$ENV_RES_TO_APP$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENVIRONMENTS$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema$ENV_TO_LABEL$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentStageSchema$ENV_STAGES$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tmd\u0001\u0002\u000e\u001c\u0001)B\u0001b\u0010\u0001\u0003\u0006\u0004%\u0019\u0001\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0003\"Aa\n\u0001BC\u0002\u0013\rq\n\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003Q\u0011!)\u0007A!b\u0001\n\u00071\u0007\u0002C7\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u00119\u0004!Q1A\u0005\u0002=D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\tk\u0002\u0011)\u0019!C\u0001m\"A!\u0010\u0001B\u0001B\u0003%q\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u00024\u0001!\t!!\u000e\t\u0013\u0005\r\u0004A1A\u0005\n\u0005\u0015\u0004\u0002CA<\u0001\u0001\u0006I!a\u001a\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0007\u0004A\u0011AAc\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\t%\u0002\u0001\"\u0003\u0003,!9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B&\u0001\u0011%!Q\n\u0005\b\u0005'\u0002A\u0011\u0002B+\u0005\u0005*eN^5s_:lWM\u001c;SKN,'O^1uS>t\u0007+\u001a:tSN$XM\\2f\u0015\taR$A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0003A\u0005\n!B]3q_NLGo\u001c:z\u0015\t\u00113%\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002%K\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003M\u001d\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003!\n1aY8n\u0007\u0001\u0019B\u0001A\u00162qA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"A\r\u001c\u000e\u0003MR!\u0001\b\u001b\u000b\u0005y)$B\u0001\u0011$\u0013\t94G\u0001\nQKJ\u001c\u0018n\u001d;f]\u000e,7+\u001e9q_J$\bCA\u001d>\u001b\u0005Q$B\u0001\u0010<\u0015\ta4%\u0001\u0002eE&\u0011aH\u000f\u0002\f\u0019&l\u0017\u000e^(gMN,G/\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001B!\t\u00115*D\u0001D\u0015\t!U)\u0001\u0003d_J,'B\u0001$H\u0003\u0011QGMY2\u000b\u0005!K\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003)\u000b1a\u001c:h\u0013\ta5I\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\u0005\u0001\u0006CA)b\u001d\t\u0011vL\u0004\u0002T=:\u0011A+\u0018\b\u0003+rs!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005eK\u0013A\u0002\u001fs_>$h(C\u0001)\u0013\t1s%\u0003\u0002%K%\u0011AhI\u0005\u0003=mJ!\u0001\u0019\u001e\u0002\u0015M\u000bHNQ;jY\u0012,'/\u0003\u0002cG\n9A)[1mK\u000e$(B\u00011;\u0003!!\u0017.\u00197fGR\u0004\u0013aC2j\u0013\u0012\u001cVM\u001d<jG\u0016,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u000e\nqa]3sm&\u001cW-\u0003\u0002mS\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003Y)gN^5s_:lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00019\u0011\u0005E\u0014X\"A\u000e\n\u0005M\\\"AF#om&\u0014xN\\7f]R\u0004VM]:jgR,gnY3\u0002/\u0015tg/\u001b:p]6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\u0013AF1qa2L7-\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0003]\u0004\"!\u001d=\n\u0005e\\\"AF!qa2L7-\u0019;j_:\u0004VM]:jgR,gnY3\u0002/\u0005\u0004\b\u000f\\5dCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0001~))qx0!\b\u0002&\u0005\u001d\u0012\u0011\u0006\t\u0003c\u0002AQaP\u0006A\u0004\u0005Csa`A\u0002\u0003/\tI\u0002\u0005\u0003\u0002\u0006\u0005MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u000e\u0005=\u0011a\u00024bGR|'/\u001f\u0006\u0004\u0003#9\u0015!\u00022fC:\u001c\u0018\u0002BA\u000b\u0003\u000f\u0011\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0005\u0005m\u0011!\u0007=meJ+\u0007o\\:ji>\u0014\u0018P\u00133cGR+W\u000e\u001d7bi\u0016DQAT\u0006A\u0004AC\u0003\"!\b\u0002\u0004\u0005]\u0011\u0011E\u0011\u0003\u0003G\tq\u0003\u001f7s%\u0016\u0004xn]5u_JL8+\u001d7ES\u0006dWm\u0019;\t\u000b\u0015\\\u00019A4\t\u000b9\\\u0001\u0019\u00019\t\u000bU\\\u0001\u0019A<)\u0007-\ti\u0003\u0005\u0003\u0002\u0006\u0005=\u0012\u0002BA\u0019\u0003\u000f\u0011\u0011\"Q;u_^L'/\u001a3\u0002\r%t7/\u001a:u)\u0011\t9$!\u0015\u0011\t\u0005e\u00121\n\b\u0005\u0003w\t9E\u0004\u0003\u0002>\u0005\u0015c\u0002BA \u0003\u0007r1\u0001VA!\u0013\t\u00013%\u0003\u0002\u001fk%\u0011A\u0004N\u0005\u0004\u0003\u0013\u001a\u0014\u0001B\"j\u0013\u0012LA!!\u0014\u0002P\t!1)[%e\u0015\r\tIe\r\u0005\b\u0003'b\u0001\u0019AA+\u0003-\u0011Xm]3sm\u0006$\u0018n\u001c8\u0011\t\u0005]\u0013qL\u0007\u0003\u00033R1AIA.\u0015\r\tifI\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u0005\u0014\u0011\f\u0002\u0017\u000b:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]\u0006!3+\u0012'F\u0007R{&+R*F%Z\u000bE+S(O?\nKvLU#T\u000bJ3\u0016\tV%P\u001d~KE)\u0006\u0002\u0002hA!\u0011\u0011NA9\u001d\u0011\tY'!\u001c\u0011\u0005]k\u0013bAA8[\u00051\u0001K]3eK\u001aLA!a\u001d\u0002v\t11\u000b\u001e:j]\u001eT1!a\u001c.\u0003\u0015\u001aV\tT#D)~\u0013ViU#S-\u0006#\u0016j\u0014(`\u0005f{&+R*F%Z\u000bE+S(O?&#\u0005%\u0001\u0005gS:$')_%e)\u0011\ti(a$\u0011\u000b1\ny(a!\n\u0007\u0005\u0005UF\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000b\u000bY)\u0004\u0002\u0002\b*\u0019\u0011\u0011R\u000e\u0002\t\u0011\fG/Y\u0005\u0005\u0003\u001b\u000b9IA\rF]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o%><\bbBAI\u001f\u0001\u0007\u0011qG\u0001\u0019K:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]&#\u0017a\u00034j]\u0012,\u0016\u000e\u001a\"z\u0013\u0012$B!a&\u00024B)A&a \u0002\u001aB!\u00111TAW\u001d\u0011\ti*a*\u000f\t\u0005}\u00151\u0015\b\u0004)\u0006\u0005\u0016bAA/G%!\u0011QUA.\u0003\tIG-\u0003\u0003\u0002*\u0006-\u0016a\u00029bG.\fw-\u001a\u0006\u0005\u0003K\u000bY&\u0003\u0003\u00020\u0006E&!B\"j+&$'\u0002BAU\u0003WCq!!.\u0011\u0001\u0004\t9$A\u0007sKN,'O^1uS>t\u0017\nZ\u0001\u0007kB$\u0017\r^3\u0015\t\u0005m\u0016\u0011\u0019\t\u0004Y\u0005u\u0016bAA`[\t9!i\\8mK\u0006t\u0007bBA*#\u0001\u0007\u0011QK\u0001\u0007g\u0016\f'o\u00195\u0015\t\u0005\u001d\u0017Q\u001c\t\t\u0003S\nI-a\u000e\u0002N&!\u00111ZA;\u0005\ri\u0015\r\u001d\t\u0007\u0003\u001f\f9.a!\u000f\t\u0005E\u0017Q\u001b\b\u0004/\u0006M\u0017\"\u0001\u0018\n\u0007\u0005%V&\u0003\u0003\u0002Z\u0006m'aA*fc*\u0019\u0011\u0011V\u0017\t\u000f\u0005}'\u00031\u0001\u0002b\u0006\t2/\u001d7XSRD\u0007+\u0019:b[\u0016$XM]:\u0011\t\u0005\r\u0018q\u001d\b\u0004%\u0006\u0015\u0018bAAUu%!\u0011\u0011^Av\u0005E\u0019\u0016\u000f\\,ji\"\u0004\u0016M]1nKR,'o\u001d\u0006\u0004\u0003SS\u0014A\u00023fY\u0016$X\r\u0006\u0003\u0002r\u0006u\bCBAz\u0003s\fY,\u0004\u0002\u0002v*\u0019\u0011q_\u0017\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003w\f)PA\u0002UefDq!!%\u0014\u0001\u0004\t9$\u0001\u0004fq&\u001cHo\u001d\u000b\t\u0003w\u0013\u0019Aa\u0002\u0003\f!9!Q\u0001\u000bA\u0002\u0005\u001d\u0014!D3om&\u0014xN\\7f]RLE\rC\u0004\u0003\nQ\u0001\r!a\u001a\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0011\u001d\u0011i\u0001\u0006a\u0001\u0005\u001f\tA\u0001Z1uKB!!\u0011\u0003B\r\u001b\t\u0011\u0019B\u0003\u0003\u0002x\nU!B\u0001B\f\u0003\u0011Q\u0017M^1\n\t\tm!1\u0003\u0002\u0005\t\u0006$X-A\tgS:$g*Z1sKN$8i\\7j]\u001e$\u0002B!\t\u0003$\t\u0015\"q\u0005\t\u0006Y\u0005}$q\u0002\u0005\b\u0005\u000b)\u0002\u0019AA4\u0011\u001d\u0011I!\u0006a\u0001\u0003OBqA!\u0004\u0016\u0001\u0004\u0011y!\u0001\nhKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8VS\u0012\u001cH\u0003\u0002B\u0017\u0005_\u0001\u0002\"!\u001b\u0002J\u0006]\u0012\u0011\u0014\u0005\b\u0003'2\u0002\u0019AA+\u0003mIgn]3si\u0016sgOU3t)>\f\u0005\u000f\u001d*fM\u0016\u0014XM\\2fgR1!Q\u0007B\u001f\u0005\u0003\u0002b!a4\u0002X\n]\u0002c\u0001\u0017\u0003:%\u0019!1H\u0017\u0003\u0007%sG\u000fC\u0004\u0003@]\u0001\r!!'\u0002\u001dI,7/\u001a:wCRLwN\\+jI\"9!1I\fA\u0002\t\u0015\u0013aB1qaVKGm\u001d\t\u0007\u0003S\u00129%!'\n\t\t%\u0013Q\u000f\u0002\u0004'\u0016$\u0018aG;qI\u0006$X-\u00128w%\u0016\u001cHk\\!qaJ+g-\u001a:f]\u000e,7\u000f\u0006\u0004\u00036\t=#\u0011\u000b\u0005\b\u0003'B\u0002\u0019AA+\u0011\u001d\u0011y\u0004\u0007a\u0001\u00033\u000b\u0001d]1oSRL'0\u001a*fg\u0016\u0014h/\u0019;j_:Le\u000e];u)\u0011\u00119F!\u0018\u0011\u00071\u0012I&C\u0002\u0003\\5\u0012A!\u00168ji\"9\u00111K\rA\u0002\u0005U\u0003f\u0001\u0001\u0003bA!!1\rB5\u001b\t\u0011)GC\u0002\u0003h\u001d\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011YG!\u001a\u0003\u0015I+\u0007o\\:ji>\u0014\u0018\u0010K\u0002\u0001\u0005_\u0002BA!\u001d\u0003x5\u0011!1\u000f\u0006\u0004\u0005kR\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:LAA!\u001f\u0003t\ty\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class EnvironmentReservationPersistence
implements PersistenceSupport,
LimitOffset {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentPersistence environmentPersistence;
    private final ApplicationPersistence applicationPersistence;
    private final String SELECT_RESERVATION_BY_RESERVATION_ID;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public String addLimitAndOffset(String query, long limitNumber, long offsetNumber) {
        return LimitOffset.addLimitAndOffset$((LimitOffset)this, (String)query, (long)limitNumber, (long)offsetNumber);
    }

    public String addLimitAndOffset(String query, Option<Object> limitNumber, Option<Object> offsetNumber) {
        return LimitOffset.addLimitAndOffset$((LimitOffset)this, (String)query, limitNumber, offsetNumber);
    }

    public Option<Object> addLimitAndOffset$default$2() {
        return LimitOffset.addLimitAndOffset$default$2$((LimitOffset)this);
    }

    public Option<Object> addLimitAndOffset$default$3() {
        return LimitOffset.addLimitAndOffset$default$3$((LimitOffset)this);
    }

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public void sqlInsertTask(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public void sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam) {
        PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Long uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Long)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Long uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Long)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, scala.collection.immutable.Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        EnvironmentReservationPersistence environmentReservationPersistence = this;
        synchronized (environmentReservationPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public EnvironmentPersistence environmentPersistence() {
        return this.environmentPersistence;
    }

    public ApplicationPersistence applicationPersistence() {
        return this.applicationPersistence;
    }

    public String insert(EnvironmentReservation reservation) {
        this.sanitizeReservationInput(reservation);
        Long environmentUid = (Long)this.environmentPersistence().findUidById(reservation.getEnvironment().getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Environment [" + reservation.getEnvironment().getId() + "] not found", new Object[0]);
        });
        Map<String, Long> applicationIdsToUids = this.getApplicationUids(reservation);
        String insertReservationStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE() + " (\n         |" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + ",\n         |" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID() + ",\n         |" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID() + ",\n         |" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + ",\n         |" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE() + ",\n         |" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE() + ")\n         |VALUES (\n         |:" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + ",\n         |:" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID() + ",\n         |:" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID() + ",\n         |:" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + ",\n         |:" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE() + ",\n         |:" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE() + ")\n       "));
        String resId = package$.MODULE$.createPersistedId(ClassTag$.MODULE$.apply(EnvironmentReservation.class), this.ciIdService());
        Long uid = IdCreator$.MODULE$.generateId();
        this.sqlInsert(insertReservationStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()), (Object)uid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()), (Object)resId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()), (Object)reservation.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()), (Object)reservation.getEndDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()), (Object)reservation.getNote())})));
        this.insertEnvResToAppReferences(uid, (scala.collection.immutable.Set<Long>)applicationIdsToUids.valuesIterator().toSet());
        return package$.MODULE$.toDisplayId(resId);
    }

    private String SELECT_RESERVATION_BY_RESERVATION_ID() {
        return this.SELECT_RESERVATION_BY_RESERVATION_ID;
    }

    public Option<EnvironmentReservationRow> findById(String environmentReservationId) {
        return this.sqlQuery(this.SELECT_RESERVATION_BY_RESERVATION_ID(), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ColumnAliases$EnvReservations$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(environmentReservationId))})), EnvironmentReservationRow$.MODULE$.reservationResultSetExtractor());
    }

    public Option<Long> findUidById(String reservationId) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|SELECT " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + "\n          |FROM " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE() + "\n          |WHERE " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID() + " = :" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()));
        return this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID()), (Object)package$.MODULE$.toPersistedId(reservationId))})), (Function1 & Serializable)rs -> package.CiUid$.MODULE$.apply(rs.getLong(EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()))).headOption();
    }

    public boolean update(EnvironmentReservation reservation) {
        Long reservationUid = (Long)this.findUidById(reservation.getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Reservation [" + reservation.getId() + "] not found", new Object[0]);
        });
        Long environmentUid = (Long)this.environmentPersistence().findUidById(reservation.getEnvironment().getId()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Environment [" + reservation.getEnvironment().getId() + "] not found", new Object[0]);
        });
        this.sanitizeReservationInput(reservation);
        this.updateEnvResToAppReferences(reservation, reservationUid);
        String updateReservationStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |UPDATE " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE() + "\n         | SET\n         |  " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + " = :" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + ",\n         |  " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE() + " = :" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE() + ",\n         |  " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE() + " = :" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE() + ",\n         |  " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID() + " = :" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID() + "\n         | WHERE\n         |  " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + " = :" + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + "\n         |"));
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(updateReservationStmt, this.paramMap2MapSqlParameterSource((Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE()), (Object)reservation.getStartDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE()), (Object)reservation.getEndDate()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE()), (Object)reservation.getNote()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID()), (Object)environmentUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID()), (Object)reservationUid)}))), (Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 == 1));
    }

    public Map<String, Seq<EnvironmentReservationRow>> search(Tuple2<String, Seq<Object>> sqlWithParameters) {
        Tuple2<String, Seq<Object>> tuple2 = sqlWithParameters;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sql = (String)tuple2._1();
        Seq params = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sql, (Object)params);
        String sql2 = (String)tuple22._1();
        Seq params2 = (Seq)tuple22._2();
        return (Map)this.jdbcTemplate().query(sql2, EnvironmentReservationRow$.MODULE$.reservationSearchResultSetExtractor(), (Object[])params2.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public Try<Object> delete(String environmentReservationId) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |DELETE FROM " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE() + "\n         | WHERE " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID() + " = :reservationId\n       "));
        return (Try)this.sqlExec(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reservationId"), (Object)package$.MODULE$.toPersistedId(environmentReservationId))})), ps -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> ps.execute()));
    }

    public boolean exists(String environmentId, String applicationId, Date date) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |SELECT 1\n         |FROM " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE() + "\n         |WHERE " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + " <= :dateToSearch\n         | AND " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE() + " >= :dateToSearch\n         | AND " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID() + " = (\n         |  SELECT " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + "\n         |  FROM " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + "\n         |  WHERE " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + " = :environmentId\n         | )\n         | AND " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + " IN (\n         |  SELECT " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID() + "\n         |  FROM " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE() + "\n         |  WHERE " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID() + " = (\n         |   SELECT " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n         |   FROM " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + "\n         |   WHERE " + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + " = :applicationId\n         |  )\n         | )\n     "));
        return BoxesRunTime.unboxToBoolean((Object)this.findOne((Function0 & Serializable)() -> this.sqlQuery(stmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationId"), (Object)package$.MODULE$.toPersistedId(applicationId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateToSearch"), (Object)date)})), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationPersistence.$anonfun$exists$2(x$3)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public Option<Date> findNearestComing(String environmentId, String applicationId, Date date) {
        String stmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |SELECT " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + "\n         |FROM " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE() + "\n         |WHERE " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE() + " >= :dateToSearch\n         | AND " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID() + " = (\n         |  SELECT " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + "\n         |  FROM " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + "\n         |  WHERE " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + " = :environmentId\n         | )\n         | AND " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + " IN (\n         |  SELECT " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID() + "\n         |  FROM " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE() + "\n         |  WHERE " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID() + " = (\n         |   SELECT " + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n         |   FROM " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + "\n         |   WHERE " + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + " = :applicationId\n         |  )\n         | )\n         |ORDER BY " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + " ASC\n     "));
        return this.findOne((Function0 & Serializable)() -> this.sqlQuery(this.addLimitAndOffset(stmt, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), this.addLimitAndOffset$default$3()), (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"environmentId"), (Object)package$.MODULE$.toPersistedId(environmentId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationId"), (Object)package$.MODULE$.toPersistedId(applicationId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateToSearch"), (Object)date)})), (Function1 & Serializable)r -> Option$.MODULE$.apply((Object)r.getTimestamp(1)))).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, Long> getApplicationUids(EnvironmentReservation reservation) {
        if (CollectionUtils.isEmpty((Collection)reservation.getApplications())) {
            return Predef$.MODULE$.Map().empty();
        }
        scala.collection.immutable.Set applicationIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(reservation.getApplications()).asScala().map((Function1 & Serializable)x$4 -> x$4.getId())).toSet();
        Map<String, Long> applicationIdsToUids = this.applicationPersistence().getUidsByIds((Iterable<String>)applicationIds);
        scala.collection.immutable.Set applicationDiff = (scala.collection.immutable.Set)((SetOps)applicationIds.map((Function1 & Serializable)id -> package$.MODULE$.toDisplayId((String)id))).diff((Set)applicationIdsToUids.keySet());
        if (applicationDiff.nonEmpty()) {
            throw new NotFoundException("Applications [" + applicationDiff.mkString(", ") + "] not found", new Object[0]);
        }
        return applicationIdsToUids;
    }

    private Seq<Object> insertEnvResToAppReferences(Long reservationUid, scala.collection.immutable.Set<Long> appUids) {
        String insertEnvResToAppStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE() + " (\n         |" + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID() + ",\n         |" + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID() + "\n         |)\n         |VALUES (\n         |:" + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID() + ",\n         |:" + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID() + "\n         |)\n         |"));
        return this.sqlBatch(insertEnvResToAppStmt, (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)appUids.map((Function1 & Serializable)appUid -> Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()), (Object)reservationUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID()), appUid)})))));
    }

    private Seq<Object> updateEnvResToAppReferences(EnvironmentReservation reservation, Long reservationUid) {
        Map<String, Long> applicationIdsToUids = this.getApplicationUids(reservation);
        String deleteEnvResToAppRefsStmt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |DELETE FROM " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE() + "\n         | WHERE\n         | " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID() + " = :" + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID() + "\n       "));
        this.sqlExec(deleteEnvResToAppRefsStmt, (Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID()), (Object)reservationUid)})), x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.execute()));
        return this.insertEnvResToAppReferences(reservationUid, (scala.collection.immutable.Set<Long>)applicationIdsToUids.valuesIterator().toSet());
    }

    private void sanitizeReservationInput(EnvironmentReservation reservation) {
        reservation.setNote(Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(reservation.getNote()), EnvironmentReservationSchema$.MODULE$.NOTE_LENGTH()));
    }

    public static final /* synthetic */ boolean $anonfun$exists$2(ResultSet x$3) {
        return x$3.getInt(1) == 1;
    }

    @Autowired
    public EnvironmentReservationPersistence(@Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, EnvironmentPersistence environmentPersistence, ApplicationPersistence applicationPersistence) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentPersistence = environmentPersistence;
        this.applicationPersistence = applicationPersistence;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        LimitOffset.$init$((LimitOffset)this);
        this.SELECT_RESERVATION_BY_RESERVATION_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |SELECT\n       | res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + " " + ColumnAliases$EnvReservations$.MODULE$.CI_UID() + ",\n       | res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID() + " " + ColumnAliases$EnvReservations$.MODULE$.ID() + ",\n       | res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.START_DATE() + " " + ColumnAliases$EnvReservations$.MODULE$.START_DATE() + ",\n       | res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.END_DATE() + " " + ColumnAliases$EnvReservations$.MODULE$.END_DATE() + ",\n       | res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.NOTE() + " " + ColumnAliases$EnvReservations$.MODULE$.NOTE() + ",\n       | env." + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + " " + ColumnAliases$Environments$.MODULE$.CI_UID() + ",\n       | env." + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ID() + " " + ColumnAliases$Environments$.MODULE$.ID() + ",\n       | envLabel." + EnvironmentLabelSchema$ENV_LABELS$.MODULE$.CI_UID() + " " + ColumnAliases$EnvLabels$.MODULE$.CI_UID() + ",\n       | envLabel." + EnvironmentLabelSchema$ENV_LABELS$.MODULE$.ID() + " " + ColumnAliases$EnvLabels$.MODULE$.ID() + ",\n       | envLabel." + EnvironmentLabelSchema$ENV_LABELS$.MODULE$.TITLE() + " " + ColumnAliases$EnvLabels$.MODULE$.TITLE() + ",\n       | envLabel." + EnvironmentLabelSchema$ENV_LABELS$.MODULE$.COLOR() + " " + ColumnAliases$EnvLabels$.MODULE$.COLOR() + ",\n       | envStages." + EnvironmentStageSchema$ENV_STAGES$.MODULE$.CI_UID() + " " + ColumnAliases$EnvStages$.MODULE$.CI_UID() + ",\n       | envStages." + EnvironmentStageSchema$ENV_STAGES$.MODULE$.ID() + " " + ColumnAliases$EnvStages$.MODULE$.ID() + ",\n       | envStages." + EnvironmentStageSchema$ENV_STAGES$.MODULE$.TITLE() + " " + ColumnAliases$EnvStages$.MODULE$.TITLE() + ",\n       | env." + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CONTENT() + " " + ColumnAliases$Environments$.MODULE$.CONTENT() + ",\n       | app." + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + " " + ColumnAliases$Applications$.MODULE$.CI_UID() + ",\n       | app." + ApplicationSchema$APPLICATIONS$.MODULE$.ID() + " " + ColumnAliases$Applications$.MODULE$.ID() + ",\n       | app." + ApplicationSchema$APPLICATIONS$.MODULE$.CONTENT() + " " + ColumnAliases$Applications$.MODULE$.CONTENT() + "\n       | FROM " + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.TABLE() + " res\n       | LEFT JOIN " + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.TABLE() + " resToApp\n       |  ON res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.CI_UID() + " = resToApp." + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.RESERVATION_UID() + "\n       | LEFT JOIN " + ApplicationSchema$APPLICATIONS$.MODULE$.TABLE() + " app\n       |  ON resToApp." + EnvironmentReservationSchema$ENV_RES_TO_APP$.MODULE$.APPLICATION_UID() + " = app." + ApplicationSchema$APPLICATIONS$.MODULE$.CI_UID() + "\n       | LEFT JOIN " + EnvironmentSchema$ENVIRONMENTS$.MODULE$.TABLE() + " env\n       |  ON res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ENVIRONMENT_UID() + " = env." + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + "\n       | LEFT JOIN " + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.TABLE() + " envToLabel\n       |  ON envToLabel." + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.ENVIRONMENT_UID() + " = env." + EnvironmentSchema$ENVIRONMENTS$.MODULE$.CI_UID() + "\n       | LEFT JOIN " + EnvironmentLabelSchema$ENV_LABELS$.MODULE$.TABLE() + " envLabel\n       |  ON envToLabel." + EnvironmentSchema$ENV_TO_LABEL$.MODULE$.LABEL_UID() + " = envLabel." + EnvironmentLabelSchema$ENV_LABELS$.MODULE$.CI_UID() + "\n       | LEFT JOIN " + EnvironmentStageSchema$ENV_STAGES$.MODULE$.TABLE() + " envStages\n       |  ON env." + EnvironmentSchema$ENVIRONMENTS$.MODULE$.ENV_STAGE_UID() + " = envStages." + EnvironmentStageSchema$ENV_STAGES$.MODULE$.CI_UID() + "\n       | WHERE res." + EnvironmentReservationSchema$ENV_RESERVATIONS$.MODULE$.ID() + " = :" + ColumnAliases$EnvReservations$.MODULE$.ID() + "\n        "));
    }
}

