import React, { useState } from 'react';
import { DotButton, DotIcon, DotInputText } from '@digital-ai/dot-components';
import HeaderComponent from '../../header/header-component';
import { ActionToolbarPortalContainer } from '@xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { useAppDispatch } from '@xlr-ui/app/js/hooks';
import { applicationLists } from '../ducks/application-list.reducer';

export interface ApplicationListHeaderProps {
    folderId: string;
}

const { searchApplications, createApplication } = applicationLists.actions;

export const ApplicationListHeaderComponent = ({ folderId }: ApplicationListHeaderProps) => {
    const dispatch = useAppDispatch();
    const [_, setTitle] = useState('');

    const filterOptions = {
        placeholder: 'Filter by application...',
    };
    const onCreateAction = () => {
        dispatch(createApplication(folderId));
    };

    const onFilterChange = (name: string) => {
        setTitle(name);
        dispatch(searchApplications({ folderId, title: name }));
    };

    return (
        <HeaderComponent>
            <ActionToolbarPortalContainer helpLink="how-to/using-applications.html">
                <DotButton onClick={onCreateAction}>New application</DotButton>
            </ActionToolbarPortalContainer>
            <DotInputText
                fullWidth={false}
                id={'header-filter'}
                name={'header-filter'}
                onChange={(e) => onFilterChange(e.target.value)}
                placeholder={filterOptions.placeholder}
                startIcon={<DotIcon iconId="search" />}
            />
        </HeaderComponent>
    );
};
