import React from 'react';
import { ReactWrapper } from 'enzyme';
import { ApplicationListHeaderComponent } from './application-list-header-component';
import { mountWithStoreAndTheme, preparePortalContainer } from '@xlr-ui/tests/unit/testing-utils';
import { RootState } from '@xlr-ui/app/js/store.types';
import { Provider } from 'react-redux';
import { applicationLists } from '../ducks/application-list.reducer';
import { DotInputText } from '@digital-ai/dot-components';

const { searchApplications, createApplication } = applicationLists.actions;

describe('Application list header component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const mount = (folderId = '', appState: RootState = {}) => {
        wrapper = mountWithStoreAndTheme(<ApplicationListHeaderComponent {...{ folderId }} />, dispatch, { ...appState });
    };

    beforeEach(() => {
        preparePortalContainer();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    it('should render properly', () => {
        mount();
        expect(wrapper.find(Provider)).toExist();
        expect(wrapper.find(ApplicationListHeaderComponent)).toExist();
    });

    it('should create default state', () => {
        const folderId = 'Folder42';
        mount(folderId);
        expect(wrapper.find('ActionToolbarPortalContainer').prop('helpLink')).toBe('how-to/using-applications.html');
    });

    it('should handle properly callbacks', () => {
        const folderId = 'Folder42';

        mount(folderId);
        const saveButton = wrapper.find('ActionToolbarPortalContainer button').first();
        expect(saveButton.exists()).toBeTruthy();
        expect(saveButton.text()).toBe('New application');
        saveButton.simulate('click');
        expect(dispatch).toHaveBeenCalledWith(createApplication(folderId));

        const filter = wrapper.find(DotInputText);
        const filterInput = filter.find('input');
        filterInput.simulate('change', { target: { value: 'new name' } });
        expect(dispatch).toHaveBeenCalledWith(searchApplications({ folderId, title: 'new name' }));
    });
});
