package com.xebialabs.xlrelease.builder

import com.xebialabs.xlrelease.domain.environments.{Application, Environment}

import scala.jdk.CollectionConverters._

object ApplicationBuilder {
  def newApplication: ApplicationBuilder = new ApplicationBuilder
}

class ApplicationBuilder {

  private var id: String = _
  private var folderId: String = _
  private var title: String = _
  private var environments: java.util.List[Environment] = List[Environment]().asJava

  def withId(id: String): ApplicationBuilder = {
    this.id = id
    this
  }

  def withFolderId(id: String): ApplicationBuilder = {
    this.folderId = id
    this
  }

  def withTitle(title: String): ApplicationBuilder = {
    this.title = title
    this
  }

  def withEnvironments(environments: java.util.List[Environment]): ApplicationBuilder = {
    this.environments = environments
    this
  }

  def withEnvironments(environments: Seq[Environment]): ApplicationBuilder = {
    this.environments = environments.asJava
    this
  }

  def build: Application = {
    val application = new Application
    application.setId(id)
    application.setFolderId(folderId)
    application.setTitle(title)
    application.setEnvironments(environments)
    application
  }
}
