import { mountWithStoreAndTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { SidebarLabelList } from './sidebar-label-list';
import { labels } from '../__mocks__/environment-list.mocks';
import React from 'react';
import { LabelModalFormComponent } from '../label/label-modal-form-component';
import { DotButton, DotCheckbox, DotInputText } from '@digital-ai/dot-components';
import LabelItem from '../../shared/label/label-item';

describe('Sidebar label list', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const onCancelEditModal = jest.fn();
    const onConfirmEditModal = jest.fn();
    const saveLabel = jest.fn();
    const onClickLabel = jest.fn();
    const labelList = labels;

    const mount = () => {
        wrapper = mountWithStoreAndTheme(<SidebarLabelList {...{ labelList, saveLabel, onClickLabel }} />, dispatch, {
            labelsState: {
                labelList: labels,
            },
        });
    };

    it('should render sidebar label list component', () => {
        mount();
        expect(wrapper).toExist();
        expect(wrapper.find(LabelItem)).toHaveLength(2);
    });

    it('should open modal for edit label', () => {
        const formComponent: ReactWrapper = mountWithStoreAndTheme(
            <LabelModalFormComponent
                labelModel={labels[0]}
                modalIsOpen={true}
                onCancelModal={onCancelEditModal}
                onConfirmModal={onConfirmEditModal}
                onOpenDelete={onCancelEditModal}
            />,
            dispatch,
            {
                labelsState: {
                    labelList: labels,
                },
            },
        );
        expect(formComponent).toExist();
        expect(formComponent.find(DotInputText).prop('id')).toBe('modal-edit-label-input');
        formComponent.find(DotInputText).invoke('onChange')({ target: { value: 'ert' } });
        const btns = formComponent.find('button');
        expect(btns.at(2).prop('data-testid')).toBe('save-btn');
        const saveBtn = btns.at(2);
        expect(saveBtn).toExist();
    });

    it('should open modal for create label', () => {
        const formComponent: ReactWrapper = mountWithStoreAndTheme(
            <LabelModalFormComponent
                labelModel={{ id: '', color: '', title: '' }}
                modalIsOpen={true}
                onCancelModal={onCancelEditModal}
                onConfirmModal={onConfirmEditModal}
                onOpenDelete={onCancelEditModal}
            />,
            dispatch,
            {
                labelsState: {
                    labelList: labels,
                },
            },
        );
        expect(formComponent).toExist();
        expect(formComponent.find(DotInputText).prop('id')).toBe('modal-edit-label-input');
        expect(formComponent.find(DotCheckbox)).toExist();
        const btns = formComponent.find(DotButton);
        expect(btns.at(1).prop('children')).toBe('Create');
    });

    it('should search labels', () => {
        mount();
        const input = wrapper.find('DotInputText#label-search');
        expect(input).toExist();
        expect(input.props().onChange).toBeDefined();
    });

    it('should should set filter name', () => {
        mount();
        const input = wrapper.find(DotInputText).at(0);
        expect(input.props().id).toStrictEqual('label-search');
        input.invoke('onChange')({ target: { value: 'nja' } });
        expect(input.props().value).toBe(undefined);
    });
});
