package com.xebialabs.xlrelease.environments.repository.sql.persistence.data

import com.xebialabs.xlrelease.environments.repository.sql.persistence.schema.EnvironmentSchema.ENVIRONMENTS
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.FOLDERS
import org.springframework.jdbc.core.ResultSetExtractor

import java.sql.ResultSet
import scala.util.Using

sealed case class EnvironmentRow(
                           override val folderId: String,
                           override val id: CiId,
                           override val json: String
                         )
  extends RowWithContent

object EnvironmentRow extends CompressionSupport {
  def apply(rs: ResultSet): EnvironmentRow = {
    val data = Using.resource(rs.getBinaryStream(ENVIRONMENTS.CONTENT)) { s =>
      decompress(s)
    }
    EnvironmentRow(
      folderId = buildFolderId(rs, FOLDERS.FOLDER_ID, FOLDERS.FOLDER_PATH),
      id = rs.getString(ENVIRONMENTS.ID),
      json = data
    )
  }

  def environmentResultSetExtractor(): ResultSetExtractor[Option[EnvironmentRow]] = rs =>
    if (rs.next()) {
      Some(EnvironmentRow(rs))
    } else {
      None
    }

  def environmentListResultSetExtractor(): ResultSetExtractor[Seq[EnvironmentRow]] = rs => {
    val resultList = scala.collection.mutable.ListBuffer.empty[EnvironmentRow]
    while (rs.next()) {
      resultList += EnvironmentRow(rs)
    }
    resultList.toSeq
  }

}
