package com.xebialabs.xlrelease.environments.repository

import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters
import com.xebialabs.xlrelease.domain.environments.Application
import com.xebialabs.xlrelease.repository.Page
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId


trait ApplicationRepository {
  def searchApplications(applicationFilters: ApplicationFilters, page: Page): Seq[Application]

  def fetchApplications(applicationIds: List[CiId]): Seq[Application]

  def fetchApplicationsByFolderId(folderId: String): Seq[Application]

  def findApplicationById(applicationId: String): Application

  def findApplicationByTitle(environmentStageTitle: String): Application

  def findInFolderByCorrelationId(folderId: String, applicationUid: String): Option[Application]

  def createApplication(application: Application): Application

  def updateApplication(application: Application): Application

  def deleteApplication(applicationId: String): Unit

  def getApplicationsDeployableOnEnvironment(environmentId: String): Seq[Application]

  def findByEnvironment(environmentId: String): List[String]
}
