import React from 'react';
import { EnvironmentListHeaderComponent } from './environment-list-header-component';
import { mountWithStoreAndTheme, preparePortalContainer, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { RootState } from '../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { stageList } from '../__mocks__/environment-list.mocks';
import { DotInputSelect, DotInputText } from '@digital-ai/dot-components';
import { environmentLists } from '../ducks/environment-list.reducer';

const { createEnvironment, searchEnvironments } = environmentLists.actions;

describe('Environment list header component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const folderId = '';
    const state: RootState = {
        environmentList: {
            stages: stageList,
        },
    };

    const mount = (folder: string = folderId, store: RootState = state) => {
        wrapper = mountWithStoreAndTheme(<EnvironmentListHeaderComponent folderId={folder} />, dispatch, store);
    };

    beforeEach(() => {
        preparePortalContainer();
        mount();
    });

    it('should render properly', () => {
        expect(wrapper.find('ActionToolbarPortalContainer').prop('helpLink')).toBe('how-to/using-environments.html');
        expect(wrapper.find('ActionToolbarPortalContainer button').first().text()).toBe('New environment');
        expect(wrapper.find(DotInputText).exists()).toBeTruthy();
        expect(wrapper.find(DotInputSelect).exists()).toBeTruthy();
    });

    it('should use callbacks properly', () => {
        wrapper.find('ActionToolbarPortalContainer button').first().simulate('click');
        expect(dispatch).toBeCalledWith(createEnvironment(''));

        const input = wrapper.find(DotInputText);
        input.invoke('onChange')({ target: { value: 'newValue' } });
        const autocomplete = wrapper.find(DotInputSelect);
        autocomplete.invoke('onChange')({ target: { value: stageList[1].title } });
        expect(dispatch).toBeCalledWith(
            searchEnvironments({
                folderId,
                stageTitle: stageList[1].title,
                title: 'newValue',
            }),
        );
    });
});
