import React from 'react';
import { StageListItemComponent } from './stage-list-item-component';
import { mountWithTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';

describe('Stage list item component', () => {
    const stage = { id: 'Stage1', title: 'DEV' };
    const onEdit = jest.fn();
    const onDelete = jest.fn();

    it('should render with model', () => {
        const item = mountWithTheme(<StageListItemComponent onDelete={onDelete} onEdit={onEdit} stage={stage} />);
        const title = item.find('.title');
        expect(title.text()).toBe('DEV');
    });

    it('should use callbacks', () => {
        const item = mountWithTheme(<StageListItemComponent onDelete={onDelete} onEdit={onEdit} stage={stage} />);
        const actions = item.find('.actions .link');
        const editAction = actions.at(0);
        editAction.simulate('click');
        expect(editAction.text()).toBe('Edit');
        expect(onEdit).toHaveBeenCalledTimes(1);
        expect(onDelete).toHaveBeenCalledTimes(0);

        const deleteAction = actions.at(1);
        expect(deleteAction.text()).toBe('Delete');
        deleteAction.simulate('click');
        expect(onDelete).toHaveBeenCalledTimes(1);
    });
});
