import { RootState } from '../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { Environment, EnvironmentFilter, EnvironmentForm, EnvironmentList, Label, LabelsState, Stage, StageState } from '../../../application-list.types';

export const getEnvironmentListState = (state: RootState): EnvironmentList => state.environmentList;

export const getFilters = (state: RootState): EnvironmentFilter => getEnvironmentListState(state).filters;
export const getEnvironments = (state: RootState): Array<Environment> => getEnvironmentListState(state).environments;

export const getEnvironmentForm = (state: RootState): EnvironmentForm => state.environmentForm;
export const getFormEnvironmentModel = (state: RootState): Environment => getEnvironmentForm(state).environmentModel;

export const getFormSaveEnabled = (state: RootState): boolean => getEnvironmentForm(state).saveEnabled;
export const getStages = (state: RootState): Array<Stage> => getEnvironmentListState(state).stages;

export const getLabelsState = (state: RootState): LabelsState => state.labelsState;

export const getLabelsList = (state: RootState): Array<Label> => getLabelsState(state).labelList;

export const getStagesState = (state: RootState): StageState => state.stageState;

export const getStageList = (stage: RootState): Array<Stage> => getStagesState(stage).stageList;
