import React from 'react';
import { mountWithStoreAndTheme, preparePortalContainer } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { labels } from '../__mocks__/environment-list.mocks';
import { LabelListComponent } from './label-list-component';
import { shallow } from 'enzyme';
import { LabelPage } from './label-page';

describe('Label page', () => {
    const dispatch = jest.fn();
    const dummyState = {
        labelsState: {
            labelList: labels,
        },
    };

    beforeEach(() => {
        preparePortalContainer();
    });

    it('should load page', () => {
        const page = shallow(<LabelPage />);
        expect(page).toExist();
    });

    it('should render container', () => {
        const labelPage = mountWithStoreAndTheme(<LabelListComponent />, dispatch, dummyState);
        expect(labelPage).toExist();
    });
});
