/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationEnvironmentFilterScope;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.service.EnvironmentLookupService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\t\u0012\u0001qA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011)\u0019!C\u0001q!Aq\b\u0001B\u0001B\u0003%\u0011\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0003V\u0001\u0011\u0005a\u000bC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j\t\u0011RI\u001c<je>tW.\u001a8u'\u0016\u0014h/[2f\u0015\t\u00112#A\u0004tKJ4\u0018nY3\u000b\u0005Q)\u0012\u0001D3om&\u0014xN\\7f]R\u001c(B\u0001\f\u0018\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u00193\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00025\u0005\u00191m\\7\u0004\u0001M!\u0001!H\u0012,!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0006g24GG\u001b\u0006\u0002Q\u0005AqM]5{u2,G-\u0003\u0002+K\t9Aj\\4hS:<\u0007C\u0001\u0017/\u001b\u0005i#B\u0001\n\u0016\u0013\tySF\u0001\rF]ZL'o\u001c8nK:$Hj\\8lkB\u001cVM\u001d<jG\u0016\fQ#\u001a8wSJ|g.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00023k5\t1G\u0003\u00025'\u0005Q!/\u001a9pg&$xN]=\n\u0005Y\u001a$!F#om&\u0014xN\\7f]R\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgV\t\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=+\u00051QM^3oiNL!AP\u001e\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u00051A(\u001b8jiz\"2A\u0011#F!\t\u0019\u0005!D\u0001\u0012\u0011\u0015\u0001D\u00011\u00012\u0011\u00159D\u00011\u0001:Q\t!q\t\u0005\u0002I'6\t\u0011J\u0003\u0002K\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00051k\u0015a\u00024bGR|'/\u001f\u0006\u0003\u001d>\u000bQAY3b]NT!\u0001U)\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AU\u0001\u0004_J<\u0017B\u0001+J\u0005%\tU\u000f^8xSJ,G-\u0001\ntK\u0006\u00148\r[#om&\u0014xN\\7f]R\u001cHCA,g!\rAVlX\u0007\u00023*\u0011!lW\u0001\u0005kRLGNC\u0001]\u0003\u0011Q\u0017M^1\n\u0005yK&\u0001\u0002'jgR\u0004\"\u0001\u00193\u000e\u0003\u0005T!\u0001\u00062\u000b\u0005\r,\u0012A\u00023p[\u0006Lg.\u0003\u0002fC\nYQI\u001c<je>tW.\u001a8u\u0011\u00159W\u00011\u0001i\u0003I)gN^5s_:lWM\u001c;GS2$XM]:\u0011\u0005%\u0004X\"\u00016\u000b\u0005-d\u0017A\u00024jYR,'O\u0003\u0002n]\u0006\u0011a/\r\u0006\u0003_V\t1!\u00199j\u0013\t\t(N\u0001\nF]ZL'o\u001c8nK:$h)\u001b7uKJ\u001c\bFA\u0003t!\t!H0D\u0001v\u0015\tQeO\u0003\u0002xq\u0006!1m\u001c:f\u0015\tI(0\u0001\u0006nS\u000e\u0014x.\\3uKJT\u0011a_\u0001\u0003S>L!!`;\u0003\u000bQKW.\u001a3\u0002'\u0019Lg\u000eZ#om&\u0014xN\\7f]R\u0014\u00150\u00133\u0015\u0007}\u000b\t\u0001C\u0004\u0002\u0004\u0019\u0001\r!!\u0002\u0002\u001b\u0015tg/\u001b:p]6,g\u000e^%e!\u0011\t9!!\u0006\u000f\t\u0005%\u0011\u0011\u0003\t\u0004\u0003\u0017yRBAA\u0007\u0015\r\tyaG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Mq$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'y\u0002F\u0001\u0004t\u0003Y1\u0017N\u001c3F]ZL'o\u001c8nK:$()\u001f+ji2,GcA0\u0002\"!9\u00111A\u0004A\u0002\u0005\u0015\u0001FA\u0004t\u0003E\u0019'/Z1uK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004?\u0006%\u0002BBA\u0016\u0011\u0001\u0007q,A\u0006f]ZL'o\u001c8nK:$\bF\u0001\u0005t\u0003E)\b\u000fZ1uK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004?\u0006M\u0002BBA\u0016\u0013\u0001\u0007q\f\u000b\u0002\ng\u0006\tB-\u001a7fi\u0016,eN^5s_:lWM\u001c;\u0015\t\u0005m\u0012\u0011\t\t\u0004=\u0005u\u0012bAA ?\t!QK\\5u\u0011\u001d\t\u0019A\u0003a\u0001\u0003\u000bA#AC:\u00023U\u0004H-\u0019;f\u0019\u0006\u0014W\r\\3e\u000b:4\u0018N]8o[\u0016tGo\u001d\u000b\u0007\u0003w\tI%a\u0015\t\u000f\u0005-3\u00021\u0001\u0002N\u0005)A.\u00192fYB\u0019\u0001-a\u0014\n\u0007\u0005E\u0013M\u0001\tF]ZL'o\u001c8nK:$H*\u00192fY\")Ac\u0003a\u0001/\u00069b-\u001b8e\u000b:4\u0018N]8o[\u0016tGo\u001d\"z\u0019\u0006\u0014W\r\u001c\u000b\u0004/\u0006e\u0003bBA&\u0019\u0001\u0007\u0011QJ\u0001\tm\u0006d\u0017\u000eZ1uKR!\u00111HA0\u0011\u0019\tY#\u0004a\u0001?\u0006ia/\u00197jI\u0006$X\rV5uY\u0016$B!a\u000f\u0002f!1\u00111\u0006\bA\u0002}\u000b1C^1mS\u0012\fG/\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:$B!a\u000f\u0002l!1\u00111F\bA\u0002}C3\u0001AA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;\u001f\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005e\u00141\u000f\u0002\b'\u0016\u0014h/[2f\u0001")
public class EnvironmentService
implements Logging,
EnvironmentLookupService {
    private final EnvironmentRepository environmentRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public java.util.List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    @Timed
    public Environment findEnvironmentByTitle(String environmentId) {
        return this.environmentRepository.findEnvironmentByTitle(environmentId);
    }

    @Timed
    public Environment createEnvironment(Environment environment) {
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment");
        this.validate(environment);
        Environment created = this.environmentRepository.createEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentCreatedEvent(created));
        return created;
    }

    @Timed
    public Environment updateEnvironment(Environment environment) {
        this.logger().debug((Function0 & Serializable)() -> "Updating environment [" + environment + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        Environment updated = this.environmentRepository.updateEnvironment(environment);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentUpdatedEvent(environment));
        return updated;
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment [" + environmentId + "]");
        Environment environment = this.environmentRepository.findEnvironmentById(environmentId);
        this.environmentRepository.deleteEnvironment(environmentId);
        this.eventBus().publish((XLReleaseEvent)new EnvironmentDeletedEvent(environment));
    }

    public void updateLabeledEnvironments(EnvironmentLabel label, java.util.List<Environment> environments) {
        environments.forEach(environment -> {
            environment.setLabels(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(environment.getLabels()).asScala().filter((Function1 & Serializable)lbl -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$updateLabeledEnvironments$2(label, lbl)))).asJava());
            this.updateEnvironment((Environment)environment);
        });
    }

    public java.util.List<Environment> findEnvironmentsByLabel(EnvironmentLabel label) {
        EnvironmentFilters filter = new EnvironmentFilters();
        filter.setLabels(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)label.getTitle(), (List)Nil$.MODULE$)).asJava());
        filter.setScope(ApplicationEnvironmentFilterScope.GLOBAL_AND_FOLDER);
        return this.searchEnvironments(filter);
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        if (environment.getDescription() != null) {
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateLabeledEnvironments$2(EnvironmentLabel label$1, EnvironmentLabel lbl) {
        String string = lbl.getId();
        String string2 = label$1.getId();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, XLReleaseEventBus eventBus) {
        this.environmentRepository = environmentRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

