import React from 'react';
import { LabelModalFormComponent } from './label-modal-form-component';
import { mountWithStoreAndTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { Label } from '../../../application-list.types';
import { RootState } from '../../../../../../../../../../core/xlr-ui/app/js/store.types';
import { DotCheckbox, DotDialog, DotInputText } from '@digital-ai/dot-components';
import { stateForForm } from '../__mocks__/environment-list.mocks';
import { TwitterPicker } from 'react-color';
import colors from '../../../../../../../../../../core/xlr-ui/app/js/colors';

describe('Label modal form component', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const onCancelModal = jest.fn();
    const onConfirmModal = jest.fn();
    const onOpenDelete = jest.fn();

    const mount = (model: Label = { id: '', color: '', title: '' }, modalIsOpen = false, state: RootState = stateForForm) => {
        wrapper = mountWithStoreAndTheme(
            <LabelModalFormComponent
                labelModel={model}
                modalIsOpen={modalIsOpen}
                onCancelModal={onCancelModal}
                onConfirmModal={onConfirmModal}
                onOpenDelete={onOpenDelete}
            />,
            dispatch,
            state,
        );
    };

    it('should render with model', () => {
        mount();
        expect(wrapper.find(DotDialog)).toExist();
    });

    it('should handle Create callbacks', () => {
        mount({ id: '', color: '', title: '' }, true, stateForForm);
        const button = wrapper.find('button[data-testid="save-btn"]');
        expect(button).toExist();
        expect(button.prop('children')).toHaveLength(2);
        expect(wrapper.find(DotCheckbox)).toExist();
        expect(wrapper.find('.additional-delete')).not.toExist();
    });

    it('should handle Save callbacks', () => {
        mount({ id: 'hg', color: 'tt', title: 'brf' }, true, stateForForm);
        const button = wrapper.find('button[data-testid="save-btn"]');
        expect(button).toExist();
        expect(button.prop('children')).toHaveLength(2);
        expect(wrapper.find('.additional-delete')).toExist();
        expect(wrapper.find(DotCheckbox)).not.toExist();
        const input = wrapper.find(DotInputText);
        expect(input).toExist();
        input.invoke('onChange')({ target: { value: 'sthElse' } });
        button.simulate('click');
        expect(onConfirmModal).toBeCalledTimes(1);
    });

    it('should handle delete callbacks', () => {
        mount({ id: 'hg', color: 'tt', title: 'brf' }, true, stateForForm);
        const button = wrapper.find('button.additional-delete');
        expect(button).toExist();
        button.simulate('click');
        expect(onOpenDelete).toBeCalledTimes(1);
    });

    it('should closeModal', () => {
        mount({ id: '1', color: 'blue', title: 'lbl' }, true, stateForForm);
        const btn = wrapper.find('button').at(1);
        expect(btn.text()).toStrictEqual('Cancel');
        btn.simulate('click');
        expect(onCancelModal).toBeCalledTimes(1);
    });

    it('should find color picker', () => {
        React.useState = jest.fn().mockReturnValue([true, {}]);
        mount({ id: '1', color: 'blue', title: 'lbl' }, true, stateForForm);
        const colorPicker = wrapper.find(TwitterPicker);
        expect(colorPicker).toExist();
        expect(colorPicker.prop('colors')).toStrictEqual([colors.blue, colors.green, colors.orange, colors.red, colors.gray, colors.purple]);
    });

    it('should tick checkbox', () => {
        React.useState = jest.fn().mockReturnValue([true, {}]);
        mount({ id: '', color: 'tt', title: 'brf' }, true, stateForForm);
        const button = wrapper.find('button[data-testid="save-btn"]');
        expect(button).toExist();
        const checkbox = wrapper.find(DotCheckbox);
        expect(checkbox).toExist();
        expect(checkbox.props().checked).toBe(true);
    });
});
