/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.service.ApplicationLookupService;
import io.micrometer.core.annotation.Timed;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\u0007\u000f\u0001eA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011)\u0019!C\u0001[!AA\u0007\u0001B\u0001B\u0003%a\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0003K\u0001\u0011\u00051\nC\u0003t\u0001\u0011\u0005A\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017\u0012!#\u00119qY&\u001c\u0017\r^5p]N+'O^5dK*\u0011q\u0002E\u0001\bg\u0016\u0014h/[2f\u0015\t\t\"#\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011eI\u0007\u0002E)\u0011qBE\u0005\u0003I\t\u0012\u0001$\u00119qY&\u001c\u0017\r^5p]2{wn[;q'\u0016\u0014h/[2f\u0003U\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\t\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002,Q\t)\u0012\t\u001d9mS\u000e\fG/[8o%\u0016\u0004xn]5u_JL\u0018\u0001C3wK:$()^:\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\n\u0002\r\u00154XM\u001c;t\u0013\t\u0019\u0004GA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)\r9\u0014H\u000f\t\u0003q\u0001i\u0011A\u0004\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006Y\u0011\u0001\rA\f\u0015\u0003\tq\u0002\"!\u0010%\u000e\u0003yR!a\u0010!\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002B\u0005\u00069a-Y2u_JL(BA\"E\u0003\u0015\u0011W-\u00198t\u0015\t)e)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u00059\u0015aA8sO&\u0011\u0011J\u0010\u0002\n\u0003V$xn^5sK\u0012\f!c]3be\u000eD\u0017\t\u001d9mS\u000e\fG/[8ogR\u0011Aj\u0017\t\u0004\u001bJ#V\"\u0001(\u000b\u0005=\u0003\u0016\u0001B;uS2T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\n!A*[:u!\t)\u0016,D\u0001W\u0015\t\trK\u0003\u0002Y%\u00051Am\\7bS:L!A\u0017,\u0003\u0017\u0005\u0003\b\u000f\\5dCRLwN\u001c\u0005\u00069\u0016\u0001\r!X\u0001\u0013CB\u0004H.[2bi&|gNR5mi\u0016\u00148\u000f\u0005\u0002_K6\tqL\u0003\u0002aC\u00061a-\u001b7uKJT!AY2\u0002\u0005Y\f$B\u00013\u0013\u0003\r\t\u0007/[\u0005\u0003M~\u0013!#\u00119qY&\u001c\u0017\r^5p]\u001aKG\u000e^3sg\"\u0012Q\u0001\u001b\t\u0003SFl\u0011A\u001b\u0006\u0003\u007f-T!\u0001\\7\u0002\t\r|'/\u001a\u0006\u0003]>\f!\"\\5de>lW\r^3s\u0015\u0005\u0001\u0018AA5p\u0013\t\u0011(NA\u0003US6,G-A\ngS:$\u0017\t\u001d9mS\u000e\fG/[8o\u0005fLE\r\u0006\u0002Uk\")aO\u0002a\u0001o\u0006i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012\u0004\"\u0001_@\u000f\u0005el\bC\u0001>\u001d\u001b\u0005Y(B\u0001?\u0019\u0003\u0019a$o\\8u}%\u0011a\u0010H\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yd\u0002F\u0001\u0004i\u0003E\u0019'/Z1uK\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0004)\u0006-\u0001BBA\u0007\u000f\u0001\u0007A+A\u0006baBd\u0017nY1uS>t\u0007FA\u0004i\u0003E)\b\u000fZ1uK\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0004)\u0006U\u0001BBA\u0007\u0011\u0001\u0007A\u000b\u000b\u0002\tQ\u0006\tB-\u001a7fi\u0016\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8\u0015\t\u0005u\u00111\u0005\t\u00047\u0005}\u0011bAA\u00119\t!QK\\5u\u0011\u00151\u0018\u00021\u0001xQ\tI\u0001.\u0001\u0014hKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8t\t\u0016\u0004Hn\\=bE2,wJ\\#om&\u0014xN\\7f]R$2\u0001TA\u0016\u0011\u0019\tiC\u0003a\u0001o\u0006iQM\u001c<je>tW.\u001a8u\u0013\u0012D#A\u00035\u0002#\u0019Lg\u000e\u001a\"z\u000b:4\u0018N]8o[\u0016tG\u000f\u0006\u0003\u00026\u0005\u0015\u0003#BA\u001c\u0003\u0003:h\u0002BA\u001d\u0003{q1A_A\u001e\u0013\u0005i\u0012bAA 9\u00059\u0001/Y2lC\u001e,\u0017bA*\u0002D)\u0019\u0011q\b\u000f\t\r\u000552\u00021\u0001xQ\tY\u0001.A\u0007wC2LG-\u0019;f)&$H.\u001a\u000b\u0005\u0003;\ti\u0005\u0003\u0004\u0002\u000e1\u0001\r\u0001\u0016\u0015\u0004\u0001\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]C)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u0017\u0002V\t91+\u001a:wS\u000e,\u0007")
public class ApplicationService
implements ApplicationLookupService {
    private final ApplicationRepository applicationRepository;
    private final XLReleaseEventBus eventBus;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public java.util.List<Application> searchApplications(ApplicationFilters applicationFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.searchApplications(applicationFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Application findApplicationById(String applicationId) {
        Application application = this.applicationRepository.findApplicationById(applicationId);
        return application;
    }

    @Timed
    public Application createApplication(Application application) {
        this.validateTitle(application);
        Application createdApplication = this.applicationRepository.createApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationCreatedEvent(createdApplication));
        return createdApplication;
    }

    @Timed
    public Application updateApplication(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validateTitle(application);
        Application updatedApplication = this.applicationRepository.updateApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationUpdatedEvent(updatedApplication));
        return updatedApplication;
    }

    @Timed
    public void deleteApplication(String applicationId) {
        Application application = this.applicationRepository.findApplicationById(applicationId);
        this.applicationRepository.deleteApplication(applicationId);
        this.eventBus().publish((XLReleaseEvent)new ApplicationDeletedEvent(application));
    }

    @Timed
    public java.util.List<Application> getApplicationsDeployableOnEnvironment(String environmentId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.getApplicationsDeployableOnEnvironment(environmentId)).asJava();
    }

    @Timed
    public List<String> findByEnvironment(String environmentId) {
        return this.applicationRepository.findByEnvironment(environmentId);
    }

    private void validateTitle(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    @Autowired
    public ApplicationService(ApplicationRepository applicationRepository, XLReleaseEventBus eventBus) {
        this.applicationRepository = applicationRepository;
        this.eventBus = eventBus;
    }
}

