package com.xebialabs.xlrelease.environments.repository.sql.persistence

import com.xebialabs.xlrelease.environments.repository.sql.persistence.data.EnvironmentSearchResultRow.decompress
import com.xebialabs.xlrelease.repository.Ids

import java.sql.ResultSet
import scala.util.Using

package object data {
  def buildFolderId(rs: ResultSet, folderIdLabel: String, folderPathLabel: String): String = {
    val rawFolderId = rs.getString(folderIdLabel)
    val rawFolderPath = rs.getString(folderPathLabel)
    Option(rawFolderId).map(folderId => s"$rawFolderPath${Ids.SEPARATOR}$folderId".dropWhile(_ == '/')).orNull
  }

  def getContent(rs: ResultSet, fieldName: String): String = {
    val envData = Using.resource(rs.getBinaryStream(fieldName)) { s =>
      decompress(s)
    }
    envData
  }
}
