import React from 'react';
import { EnvironmentListItemComponent } from './environment-list-item-component';
import { mountWithStoreAndTheme } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { envWithId } from '../__mocks__/environment-list.mocks';
import { environmentLists } from '../ducks/environment-list.reducer';
import LabelItem from '../../shared/label/label-item';

const { editEnvironment } = environmentLists.actions;

describe('Environment list item component', () => {
    const dispatch = jest.fn();

    it('should render', () => {
        const onDelete = jest.fn();
        const component = mountWithStoreAndTheme(<EnvironmentListItemComponent environment={envWithId} folderId={''} onDelete={onDelete} />, dispatch, {});

        const body = component.find('.environment-panel');
        expect(body.exists()).toBeTruthy();

        const envIcon = component.find('.mrs');
        expect(envIcon.exists()).toBeTruthy();
    });

    it('should render one label item', () => {
        const onDelete = jest.fn();
        const component = mountWithStoreAndTheme(<EnvironmentListItemComponent environment={envWithId} folderId={''} onDelete={onDelete} />, dispatch, {});
        expect(component.find(LabelItem)).toHaveLength(1);
    });

    it('should edit environment', () => {
        const onDelete = jest.fn();
        const component = mountWithStoreAndTheme(<EnvironmentListItemComponent environment={envWithId} folderId={''} onDelete={onDelete} />, dispatch, {});

        const edit = component.find('span[data-test="edit-action"]');
        edit.simulate('click');
        expect(dispatch).toBeCalledWith(editEnvironment({ envId: envWithId.id, folderId: '' }));
    });

    it('should delete environment', () => {
        const onDelete = jest.fn();
        const component = mountWithStoreAndTheme(<EnvironmentListItemComponent environment={envWithId} folderId={''} onDelete={onDelete} />, dispatch, {});

        const deleteIcon = component.find('span[data-test="delete-action"]');
        deleteIcon.simulate('click');
        expect(onDelete).toBeCalledWith(envWithId);
    });
});
