import { all, call, put, takeLatest, throttle } from 'redux-saga/effects';
import isEmpty from 'lodash/isEmpty';
import ToastrFactory from '../../../../../../../../../../core/xlr-ui/app/js/util/toastrFactory';
import { labelsState } from './labels.reducer';
import { actionTypes as schedulerActionTypes } from '../../../actions/scheduling-actions';
import { PayloadAction } from '@reduxjs/toolkit';
import { httpDELETE, httpPOST, httpPUT } from '../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { byTitle } from '../../../utils';
import { Label, ScheduleInitHeader } from '../../../application-list.types';
export const toastr = ToastrFactory();

const { saveLabel, setLabels, deleteLabel, searchLabels } = labelsState.actions;
export function* _searchLabels(action: PayloadAction<string>) {
    try {
        const { data: labels } = yield call(httpPOST, 'api/v1/environments/labels/search', { title: action.payload });
        yield put(setLabels(labels.sort(byTitle)));
    } catch (e) {
        // eslint-disable-next-line no-console,angular/log
        yield call(console.error, 'Labels saga: ', e);
    }
}

export function* _saveLabel(action: PayloadAction<Label>) {
    const envLabel = action.payload;

    try {
        if (isEmpty(envLabel.id)) {
            yield call(httpPOST, 'api/v1/environments/labels', envLabel);
            yield call(toastr.success, `Label [${envLabel.title}] created`);
        } else {
            yield call(httpPUT, `api/v1/environments/labels/${envLabel.id}`, envLabel);
            yield call(toastr.success, `Label [${envLabel.title}] updated`);
        }
        yield put(searchLabels(''));
    } catch (e) {
        // eslint-disable-next-line no-console,angular/log
        yield call(console.error, 'Labels saga: ', e);
    }
}

export function* _deleteLabel(action: PayloadAction<Label>) {
    const envLabel = action.payload;
    try {
        yield call(httpDELETE, `api/v1/environments/labels/${envLabel.id}`);
        yield call(toastr.success, `Label [${envLabel.title}] deleted`);
        yield put(searchLabels(''));
    } catch (e) {
        // eslint-disable-next-line no-console,angular/log
        yield call(console.error, 'Labels saga: ', e);
    }
}

export function* _scheduleInitHeader(action: PayloadAction<ScheduleInitHeader>) {
    const labels = action.payload.labels;
    yield put(setLabels(labels.sort(byTitle)));
}

const debounce = 200;
export default function* labelSaga() {
    yield all([
        takeLatest(saveLabel, _saveLabel),
        takeLatest(deleteLabel, _deleteLabel),
        takeLatest(searchLabels, _searchLabels),
        throttle(debounce, schedulerActionTypes.SCHEDULE_INIT_HEADER_SUCCESS, _scheduleInitHeader),
    ]);
}
