/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.xlrelease.api.v1.EnvironmentReservationApi;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentReservationForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentReservationView;
import com.xebialabs.xlrelease.api.v1.views.search.EnvironmentReservationSearchView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentReservationSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentReservationService;
import io.micrometer.core.annotation.Timed;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EnvironmentReservationApiImpl
implements EnvironmentReservationApi {
    private EnvironmentReservationService environmentReservationService;
    private EnvironmentReservationSecurity environmentReservationSecurity;
    private ApplicationService applicationService;

    @Autowired
    public EnvironmentReservationApiImpl(EnvironmentReservationService environmentReservationService, EnvironmentReservationSecurity environmentReservationSecurity, ApplicationService applicationService) {
        this.environmentReservationService = environmentReservationService;
        this.environmentReservationSecurity = environmentReservationSecurity;
        this.applicationService = applicationService;
    }

    @Timed
    public EnvironmentReservationView createReservation(EnvironmentReservationForm environmentReservationForm) {
        this.environmentReservationSecurity.checkCreate();
        EnvironmentReservation reservation = environmentReservationForm.toEnvironmentReservation();
        return EnvironmentReservationView.fromEnvironmentReservation((EnvironmentReservation)this.environmentReservationService.createReservation(reservation));
    }

    @Timed
    public EnvironmentReservationView getReservation(String environmentReservationId) {
        this.environmentReservationSecurity.checkView();
        return EnvironmentReservationView.fromEnvironmentReservation((EnvironmentReservation)this.environmentReservationService.findReservationById(environmentReservationId));
    }

    @Timed
    public EnvironmentReservationView updateReservation(String environmentReservationId, EnvironmentReservationForm environmentReservationForm) {
        this.environmentReservationSecurity.checkEdit();
        EnvironmentReservation reservation = environmentReservationForm.toEnvironmentReservation();
        reservation.setId(environmentReservationId);
        return EnvironmentReservationView.fromEnvironmentReservation((EnvironmentReservation)this.environmentReservationService.updateReservation(reservation));
    }

    @Timed
    public List<EnvironmentReservationSearchView> searchReservations(ReservationFilters filters) {
        this.environmentReservationSecurity.checkView();
        filters.validate();
        return this.environmentReservationService.searchReservations(filters).entrySet().stream().map(e -> EnvironmentReservationSearchView.from((Environment)((Environment)e.getKey()), (List)((List)e.getValue()))).collect(Collectors.toList());
    }

    @Timed
    public void delete(String environmentReservationId) {
        this.environmentReservationSecurity.checkEdit();
        this.environmentReservationService.deleteReservation(environmentReservationId);
    }

    @Timed
    public void addApplication(String environmentReservationId, String applicationId) {
        this.environmentReservationSecurity.checkEdit();
        EnvironmentReservation environmentReservation = this.environmentReservationService.findReservationById(environmentReservationId);
        Application application = this.applicationService.findApplicationById(applicationId);
        environmentReservation.addApplication(application);
        this.environmentReservationService.updateReservation(environmentReservation);
    }

    @Timed
    public EnvironmentReservation create(EnvironmentReservation environmentReservation) {
        this.environmentReservationSecurity.checkCreate();
        return this.environmentReservationService.createReservation(environmentReservation);
    }

    @Timed
    public EnvironmentReservation getById(String environmentReservationId) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.findReservationById(environmentReservationId);
    }

    @Timed
    public EnvironmentReservation update(EnvironmentReservation environmentReservation) {
        this.environmentReservationSecurity.checkEdit();
        return this.environmentReservationService.updateReservation(environmentReservation);
    }

    @Timed
    public Map<String, List<EnvironmentReservation>> search(ReservationFilters filters) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.searchReservations(filters).entrySet().stream().collect(Collectors.toMap(entry -> ((Environment)entry.getKey()).getId(), Map.Entry::getValue));
    }

    @Timed
    public boolean hasReservation(String environmentId, String applicationId) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.existsReservation(environmentId, applicationId);
    }

    @Timed
    public Date nearestComingReservation(String environmentId, String applicationId) {
        this.environmentReservationSecurity.checkView();
        return this.environmentReservationService.nearestComingReservation(environmentId, applicationId);
    }
}

