package com.xebialabs.xlrelease.environments.repository.sql.persistence.builder

import com.xebialabs.xlrelease.api.v1.filter.{ApplicationEnvironmentFilterScope, WithFolderFiltering}
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid

trait InFolderSqlBuilder extends WithFolderFiltering {

  def applyFolderFiltering(maybeScope: Option[ApplicationEnvironmentFilterScope], maybeFolder: Option[CiUid]): Unit = {
    maybeScope match {
      case Some(ApplicationEnvironmentFilterScope.FOLDER) =>
        maybeFolder
          .foreach(withFolder)
      case Some(ApplicationEnvironmentFilterScope.GLOBAL) =>
        withNoFolder()
      case Some(ApplicationEnvironmentFilterScope.GLOBAL_AND_FOLDER) =>
        maybeFolder
          .foreach(withGlobalAndFolder)
      case None =>
        maybeFolder
          .map(withFolder)
          .getOrElse(withNoFolder())
      case Some(ApplicationEnvironmentFilterScope.ALL) =>
    }
  }
}
