package com.xebialabs.xlrelease.environments.repository.sql.persistence.data

import com.xebialabs.xlrelease.environments.repository.sql.persistence.ResultSetExtension
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport
import org.springframework.jdbc.core.ResultSetExtractor

import java.sql.ResultSet
import scala.collection.mutable

sealed case class EnvironmentSearchResultRow(override val id: CiId,
                                             override val folderId: String,
                                             labels: Vector[EnvironmentLabelRow],
                                             override val json: String)
  extends RowWithContent


object EnvironmentSearchResultRow extends CompressionSupport {
  sealed case class EnvironmentSearchRow(folderId: String, stage: EnvironmentStageRow, envJson: String)

  def environmentSearchResultSetExtractor(): ResultSetExtractor[Vector[EnvironmentSearchResultRow]] = rs => {
    val envMap = mutable.Map.empty[String, EnvironmentSearchRow]
    val envToLabelsMap = mutable.Map.empty[String, mutable.Set[EnvironmentLabelRow]]
    while (rs.next()) {
      mapEnvironmentRow(rs, envMap, envToLabelsMap)
    }

    envMap.view.map { case (envId, envRow) =>
      EnvironmentSearchResultRow(
        envId,
        envRow.folderId,
        envToLabelsMap.getOrElse(envId, Vector.empty[EnvironmentLabelRow]).toVector,
        envRow.envJson
      )
    }.toVector
  }

  def mapEnvironmentRow(rs: ResultSet,
                                envMap: mutable.Map[CiId, EnvironmentSearchRow],
                                envToLabelsMap: mutable.Map[CiId, mutable.Set[EnvironmentLabelRow]]): CiId = {
    val stageMap = mutable.Map.empty[CiId, EnvironmentStageRow]
    val labelMap = mutable.Map.empty[CiId, EnvironmentLabelRow]
    val envId = rs.getCiId(ColumnAliases.Environments.ID)
    val stage: EnvironmentStageRow = mapEnvironmentStageRow(rs, stageMap)

    envMap.getOrElseUpdate(envId, EnvironmentSearchRow(
      buildFolderId(rs, ColumnAliases.Environments.FOLDER_ID, ColumnAliases.Environments.FOLDER_PATH),
      stage,
      getContent(rs, ColumnAliases.Environments.CONTENT)
    ))

    if (rs.getCiId(ColumnAliases.EnvLabels.ID) != null) {
      mapEnvironmentLabelRow(rs, envToLabelsMap, labelMap, envId)
    }
    envId
  }

  private def mapEnvironmentLabelRow(rs: ResultSet,
                                     envToLabelsMap: mutable.Map[CiId, mutable.Set[EnvironmentLabelRow]],
                                     labelMap: mutable.Map[CiId, EnvironmentLabelRow],
                                     envId: CiId) = {
    val labelId = rs.getCiId(ColumnAliases.EnvLabels.ID)
    val label = labelMap.getOrElseUpdate(labelId, EnvironmentLabelRow(
      rs.getCiId(ColumnAliases.EnvLabels.ID),
      rs.getString(ColumnAliases.EnvLabels.TITLE),
      rs.getString(ColumnAliases.EnvLabels.COLOR)
    ))
    envToLabelsMap.getOrElseUpdate(envId, mutable.Set.empty) += label
  }

  private def mapEnvironmentStageRow(rs: ResultSet, stageMap: mutable.Map[CiId, EnvironmentStageRow]) = {
    val stageId = rs.getString(ColumnAliases.EnvStages.TITLE)
    val stage = stageMap.getOrElseUpdate(stageId,
      EnvironmentStageRow(
        rs.getCiId(ColumnAliases.EnvStages.ID),
        rs.getCiId(ColumnAliases.EnvStages.TITLE)
      ))
    stage
  }
}

