import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';

export interface ApplicationEditHeaderProps {
    onCancel: () => void;
    onSave: () => void;
    saveCaption: string;
    saveEnabled: boolean;
}
export const ApplicationEditHeaderComponent = ({ saveCaption, saveEnabled, onSave, onCancel }: ApplicationEditHeaderProps) => {
    return (
        <ActionToolbarPortalContainer helpLink="how-to/using-applications.html">
            <DotButton onClick={onCancel} type="text">
                Cancel
            </DotButton>
            <DotButton disabled={!saveEnabled} onClick={onSave}>
                {saveCaption}
            </DotButton>
        </ActionToolbarPortalContainer>
    );
};
