import React, { useState } from 'react';
import { DotButton, DotDialog, DotInputText, DotThemeProvider } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { itemAlreadyDefined } from '../../../../../../../../../../core/xlr-ui/app/react/utils/validators';
import HeaderComponent from './../../header/header-component';

import './../../../styles/modal.less';
import { Stage } from '../../../application-list.types';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { getStageList } from '../ducks/environment-list.selectors';
import { stageState } from '../ducks/stage.reducer';

const nameOptions = {
    label: 'Name',
    placeholder: 'Add...',
    description: 'Name of the stage',
    required: true,
};

const { saveStage } = stageState.actions;
export interface StageListHeaderProps {
    onFilterChange: (text: string) => void;
}

const errorMsg = 'Stage already exists';

export const StageListHeaderComponent = ({ onFilterChange }: StageListHeaderProps) => {
    const dispatch = useAppDispatch();
    const stageList = useAppSelector(getStageList);
    const [createButtonDisabled, setButtonDisabled] = useState(false);
    const [modalIsOpen, setModalIsOpen] = useState(false);
    const [valid, setValid] = useState(true);
    const [stageModel, setStageModel] = useState({
        id: '',
        title: '',
    } as Stage);

    const onSubmit = () => {
        dispatch(saveStage(stageModel));
        setModalIsOpen(false);
    };

    const closeModal = () => {
        setModalIsOpen(false);
    };

    const onModelChange = (title: string) => {
        if (itemAlreadyDefined(stageList, null, 'title', title)) {
            setButtonDisabled(true);
            setValid(false);
            return;
        }
        setButtonDisabled(false);
        setValid(true);
        setStageModel({ ...stageModel, title });
    };

    const filterOptions = { placeholder: 'Filter by stage...' };

    return (
        <HeaderComponent>
            <DotThemeProvider>
                <ActionToolbarPortalContainer helpLink="how-to/using-environments.html">
                    <DotButton onClick={() => setModalIsOpen(true)}>New stage</DotButton>
                </ActionToolbarPortalContainer>
                <DotInputText
                    fullWidth={false}
                    helperText={valid ? '' : errorMsg}
                    id={'stageFilter'}
                    label={'Stage filter'}
                    name={'stageFilter'}
                    onChange={(e) => onFilterChange(e.target.value)}
                    persistentLabel={true}
                    placeholder={filterOptions.placeholder}
                />
                <DotDialog
                    className="xl-default-modal"
                    closeIconVisible={true}
                    closeOnSubmit={false}
                    onCancel={closeModal}
                    onSubmit={onSubmit}
                    open={modalIsOpen}
                    submitButtonProps={{
                        className: 'submitBtn',
                        disabled: createButtonDisabled,
                        label: 'Create',
                    }}
                    title={'New stage'}
                >
                    <DotInputText
                        autoFocus
                        error={!valid}
                        helperText={valid ? '' : errorMsg}
                        id={'stage-title'}
                        label={nameOptions.label}
                        maxLength={255}
                        name={'stage-title'}
                        onChange={(e) => onModelChange(e.target.value)}
                        persistentLabel={true}
                        placeholder={nameOptions.placeholder}
                    />
                </DotDialog>
            </DotThemeProvider>
        </HeaderComponent>
    );
};
