import React, { useState } from 'react';
import classNames from 'classnames';
import LabelItem from '../../shared/label/label-item';
import { DotIconWrapper } from '../../../../../../../../../../core/xlr-ui/app/features/common/components/dot-icon-wrapper/dot-icon-wrapper';

import './environment-list-item-component.less';
import { Environment } from '../../../application-list.types';
import { useAppDispatch } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { environmentLists } from '../ducks/environment-list.reducer';

export interface EnvironmentListItemProps {
    environment: Environment;
    folderId: string | null;
    onDelete: (env: Environment) => void;
}

const { editEnvironment } = environmentLists.actions;
export const EnvironmentListItemComponent = ({ environment, folderId, onDelete }: EnvironmentListItemProps) => {
    const dispatch = useAppDispatch();
    const [isSelected, _] = useState(false);

    const onEditEnvironment = (event: React.MouseEvent) => {
        event.stopPropagation();
        dispatch(editEnvironment({ envId: environment.id, folderId }));
    };

    const onDeleteEnvironment = (event: React.MouseEvent) => {
        event.stopPropagation();
        onDelete(environment);
    };

    const renderEnvironmentTitle = () => {
        return (
            <div className="environment-title-container">
                <div className="col-xs-7 environment-title" title={environment.title}>
                    <DotIconWrapper className="mrs" iconId="environment" />
                    <strong>{environment.title}</strong>
                </div>
                <span className="col-xs-2">{environment.stage.title}</span>
                <div className="actions-container col-xs-3">
                    <div className="actions pull-right">
                        <span className="link color-inherited" data-test="edit-action" onClick={(e) => onEditEnvironment(e)}>
                            <i className="menu-item-icon xl-icon edit-icon" title="Edit" />
                            <span className="action-label">Edit</span>
                        </span>
                        <span className="link delete" data-test="delete-action" onClick={(e) => onDeleteEnvironment(e)}>
                            <i className="menu-item-icon xl-icon delete-icon" title="Delete" />
                            <span className="action-label">Delete</span>
                        </span>
                    </div>
                </div>
            </div>
        );
    };

    const renderEnvironmentLabels = () => {
        if (!environment.labels.length) {
            return null;
        }
        return (
            <div className="environment-labels">
                {environment.labels.map((type) => (
                    <LabelItem envLabel={type} key={type.id} />
                ))}
            </div>
        );
    };

    const panelClass = classNames('panel', 'panel-default', 'environment-panel', { 'panel-hover': isSelected });

    return (
        <div className={panelClass} onClick={(e) => onEditEnvironment(e)}>
            {renderEnvironmentTitle()}
            {(environment.description || !!environment.labels.length) && <div className="environment-title-separator"></div>}
            {environment.description && <div className="environment-description">{environment.description}</div>}
            {renderEnvironmentLabels()}
        </div>
    );
};
