import { all, call, put, takeLatest } from 'redux-saga/effects';
import ToastrFactory from '../../../../../../../../../../core/xlr-ui/app/js/util/toastrFactory';
import getAngularService from '../../../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import isEmpty from 'lodash/isEmpty';
import map from 'lodash/map';
import { addConfirmLeavePopup, removeConfirmLeavePopup } from '../../../../../../../../../../core/xlr-ui/app/react/utils/sagas';
import { environmentForm, initialState } from './environment-form.reducer';
import { Environment, EnvironmentEdit } from '../../../application-list.types';
import { PayloadAction } from '@reduxjs/toolkit';
import { httpGET, httpPOST, httpPUT } from '../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { IStateService } from 'angular-ui-router';
import { labelsState } from './labels.reducer';
import { stageState } from './stage.reducer';

const { cancelForm, initForm, pristineFormChanged, saveForm, setEnvironments, setEnvironmentModel } = environmentForm.actions;

const { searchStages } = stageState.actions;

const { searchLabels } = labelsState.actions;

export const toastr = ToastrFactory();

export function* save(action: PayloadAction<Environment>) {
    try {
        const $state: IStateService = yield call(getAngularService, '$state');
        const environment = action.payload;
        const environmentFormFields = {
            title: environment.title,
            stageId: environment.stage.id,
            description: environment.description,
            labelIds: map(environment.labels, 'id'),
            folderId: environment.folderId,
        };
        yield call(removeConfirmLeavePopup);
        if (isEmpty(environment.id)) {
            yield call(httpPOST, 'api/v1/environments', environmentFormFields);
            yield call(toastr.success, `Environment [${environment.title}] created`);
        } else {
            yield call(httpPUT, `api/v1/environments/${environment.id}`, environmentFormFields);
            yield call(toastr.success, `Environment [${environment.title}] updated`);
        }
        if (isEmpty(environment.folderId)) {
            $state.go('environmentList');
        } else {
            $state.go('folders.detail.folderEnvironment');
        }
    } catch (e) {
        /* eslint-disable no-console, angular/log */
        yield call(console.error, 'Environment form saga:', e);
        /* eslint-enable */
    }
}

export function* cancel(action: PayloadAction<string>) {
    const folderId = action.payload;
    yield call(removeConfirmLeavePopup);
    const $state: IStateService = yield call(getAngularService, '$state');
    if (isEmpty(folderId)) {
        $state.go('environmentList');
    } else {
        $state.go('folders.detail.folderEnvironment');
    }
}

export function* initEnvironmentForm(action: PayloadAction<EnvironmentEdit>) {
    const { envId, folderId } = action.payload;
    try {
        if (envId) {
            const { data: environments } = yield call(httpPOST, 'api/v1/environments/search', { folderId });
            const { data: environment } = yield call(httpGET, `api/v1/environments/${envId}`);
            yield put(setEnvironments(environments));
            yield put(setEnvironmentModel(environment));
        } else {
            const { data: environments } = yield call(httpPOST, 'api/v1/environments/search', { folderId });
            yield put(setEnvironments(environments));
            yield put(setEnvironmentModel(initialState.environmentModel));
        }
        yield put(searchStages(''));
        yield put(searchLabels(''));
    } catch (e) {
        // eslint-disable-next-line
        yield call(console.error, 'Environment-form-saga: ', e);
    }
}

export default function* environmentFormSaga() {
    yield all([
        takeLatest(cancelForm, cancel),
        takeLatest(saveForm, save),
        takeLatest(initForm, initEnvironmentForm),
        takeLatest(pristineFormChanged, addConfirmLeavePopup),
    ]);
}
