import React from 'react';
import { DotButton, DotIcon, DotInputText } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import HeaderComponent from '../../header/header-component';

import '../../../styles/modal.less';
import './label-modal-form-component.less';

export interface LabelListHeaderProps {
    onCreate: () => void;
    onFilterChange: (title: string) => void;
}

export const LabelListHeaderComponent = ({ onCreate, onFilterChange }: LabelListHeaderProps) => {
    const showCreateModal = () => {
        onCreate();
    };

    const filterFieldMetadata = { placeholder: 'Filter by label...' };

    return (
        <HeaderComponent>
            <ActionToolbarPortalContainer helpLink="how-to/using-environments.html">
                <DotButton onClick={showCreateModal}>New label</DotButton>
            </ActionToolbarPortalContainer>
            <DotInputText
                fullWidth={false}
                id={'label-search'}
                name={'label-search'}
                onChange={(e) => onFilterChange(e.target.value)}
                placeholder={filterFieldMetadata.placeholder}
                startIcon={<DotIcon iconId="search" />}
            />
        </HeaderComponent>
    );
};
