import React from 'react';
import { mountComponentWithStore, preparePortalContainer, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { ApplicationListComponent } from './application-list-component';
import { ApplicationListHeaderComponent } from './application-list-header-component';
import { beginState } from '../__mocks__/application-list.mocks';
import { Provider } from 'react-redux';
import { ApplicationListPage } from './application-list-page';
import { shallow } from 'enzyme';

describe('Application list page', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();
    const folderId = '';

    const mount = (folder: string = folderId) => {
        wrapper = mountComponentWithStore(<ApplicationListComponent {...{ folderId: folder }} />, dispatch, beginState);
    };

    beforeEach(() => {
        preparePortalContainer();
        mount();
    });

    it('should load page', () => {
        const page = shallow(<ApplicationListPage folderId={folderId} />);
        expect(page).toExist();
    });

    it('should render container', () => {
        expect(wrapper.find(Provider)).toExist();
        const header = wrapper.find(ApplicationListHeaderComponent);
        expect(header).toExist();
    });
});
