import React, { useState } from 'react';
import sortBy from 'lodash/sortBy';
import { DotButton, DotIcon, DotInputSelect, DotInputText } from '@digital-ai/dot-components';
import HeaderComponent from '../../header/header-component';
import { ActionToolbarPortalContainer } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { environmentLists } from '../ducks/environment-list.reducer';
import { getEnvironmentListState } from '../ducks/environment-list.selectors';

const defaultSelectOption = {
    option: 'Filter by stage...',
};

const filterOptions = {
    placeholder: 'Filter by environment...',
};

export interface EnvironmentListHeaderProps {
    folderId: string;
}

const { createEnvironment, searchEnvironments, setFilterTitle, setFilterStage } = environmentLists.actions;

export const EnvironmentListHeaderComponent = ({ folderId }: EnvironmentListHeaderProps) => {
    const dispatch = useAppDispatch();

    const [filterEnvironmentName, setFilterEnvironmentName] = useState('');
    const [filterStageTitle, setFilterStageTitle] = useState('');

    const stages = useAppSelector(getEnvironmentListState).stages;

    const stageOptions = sortBy(
        stages.map((stage) => {
            return { option: stage.title };
        }),
        ['option'],
    );

    const onAddNewEnvironment = () => {
        dispatch(createEnvironment(folderId));
    };

    const onFilterChange = (envName: string) => {
        setFilterEnvironmentName(envName);
        dispatch(setFilterTitle(envName));
        dispatch(
            searchEnvironments({
                folderId,
                stageTitle: filterStageTitle,
                title: envName,
            }),
        );
    };

    const onStageChange = (stage: string) => {
        const envStage = stage === defaultSelectOption.option ? '' : stage;
        setFilterStageTitle(envStage);
        dispatch(setFilterStage(stages.find((s) => s.title === envStage) || { id: '', title: '' }));
        dispatch(
            searchEnvironments({
                folderId,
                stageTitle: envStage,
                title: filterEnvironmentName,
            }),
        );
    };

    return (
        <HeaderComponent>
            <ActionToolbarPortalContainer helpLink="how-to/using-environments.html">
                <DotButton onClick={onAddNewEnvironment}>New environment</DotButton>
            </ActionToolbarPortalContainer>
            <DotInputText
                fullWidth={false}
                id={'env-header-filter'}
                name={'env-header-filter'}
                onChange={(e) => onFilterChange(e.target.value)}
                placeholder={filterOptions.placeholder}
                startIcon={<DotIcon iconId="search" />}
            />

            <DotInputSelect
                className="env-stage-filter"
                defaultValue={defaultSelectOption.option}
                id={'stageSelector'}
                name={'stageSelector'}
                onChange={(e) => onStageChange(e.target.value)}
                options={[defaultSelectOption, ...stageOptions]}
            />
        </HeaderComponent>
    );
};
