import { stageState } from './stage.reducer';
import { SagaIterator } from 'redux-saga';
import stageSaga, { _deleteStage, _saveStage, _searchStages, _scheduleInitHeader, toastr } from './stage.saga';
import { all, call, put, takeLatest, throttle } from 'redux-saga/effects';
import { actionTypes as schedulerActionTypes } from '../../../actions/scheduling-actions';
import { httpDELETE, httpPOST, httpPUT } from '../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { stage, stages } from '../__mocks__/environment-list.mocks';
import { byTitle } from '../../../utils';

const { setStages, searchStages, deleteStage, saveStage } = stageState.actions;

describe('stages.saga', () => {
    it('should yield all effects', () => {
        const gen: SagaIterator = stageSaga();
        expect(gen.next().value).toStrictEqual(
            all([
                takeLatest(saveStage, _saveStage),
                takeLatest(deleteStage, _deleteStage),
                takeLatest(searchStages, _searchStages),
                throttle(200, schedulerActionTypes.SCHEDULE_INIT_HEADER_SUCCESS, _scheduleInitHeader),
            ]),
        );
        expect(gen.next().done).toBe(true);
    });

    describe('search stages', () => {
        it('should search stages', () => {
            const gen: SagaIterator = _searchStages({
                payload: '',
                type: 'whatever',
            });
            expect(gen.next().value).toStrictEqual(call(httpPOST, 'api/v1/environments/stages/search', { title: '' }));
            expect(gen.next({ data: stages }).value).toStrictEqual(put(setStages(stages.sort(byTitle))));
            expect(gen.next().done).toBe(true);
        });
    });

    describe('save stage', () => {
        const locStage = { id: '', title: 'saveStage' };
        it('should save stage', () => {
            const gen: SagaIterator = _saveStage({
                payload: locStage,
                type: 'whatever',
            });
            expect(gen.next().value).toStrictEqual(call(httpPOST, 'api/v1/environments/stages', locStage));
            expect(gen.next().value).toStrictEqual(call(toastr.success, `Stage [${locStage.title}] created`));
            expect(gen.next().value).toStrictEqual(put(searchStages('')));
            expect(gen.next().done).toBe(true);
        });

        it('should update stage', () => {
            const gen: SagaIterator = _saveStage({
                payload: stage,
                type: 'whatever',
            });
            expect(gen.next().value).toStrictEqual(call(httpPUT, `api/v1/environments/stages/${stage.id}`, stage));
            expect(gen.next().value).toStrictEqual(call(toastr.success, `Stage [${stage.title}] updated`));
            expect(gen.next().value).toStrictEqual(put(searchStages('')));
            expect(gen.next().done).toBe(true);
        });
    });

    describe('delete stage', () => {
        it('should delete stage', () => {
            const gen: SagaIterator = _deleteStage({
                payload: stage,
                type: 'whatever',
            });
            expect(gen.next().value).toStrictEqual(call(httpDELETE, `api/v1/environments/stages/${stage.id}`));
            expect(gen.next().value).toStrictEqual(call(toastr.success, `Stage [${stage.title}] deleted`));
            expect(gen.next().value).toStrictEqual(put(searchStages('')));
            expect(gen.next().done).toBe(true);
        });
    });

    describe('schedule init header', () => {
        it('should set stage', () => {
            const gen: SagaIterator = _scheduleInitHeader({
                payload: {
                    applications: [],
                    stages,
                    labels: [],
                },
                type: 'whatever',
            });
            expect(gen.next().value).toStrictEqual(put(setStages(stages.sort(byTitle))));
            expect(gen.next().done).toBeTruthy();
        });
    });
});
