export interface Label {
    color: string;
    id: string | null;
    title: string;
}

export interface Stage {
    id: string;
    title: string;
}

export interface Environment {
    description: string;
    folderId: string | null;
    id: string;
    labels: Array<Label>;
    stage: Stage;
    title: string;
}

export interface ApplicationName {
    folderId: string | null;
    title: string;
}

export interface ApplicationEdit {
    appId: string;
    folderId: string | null;
}

export interface Application {
    environments: Array<Environment>;
    folderId: string | null;
    id: string;
    title: string;
}

export interface ApplicationList {
    applicationToDelete: Application;
    applications: Array<Application>;
    deleteModalIsOpen: boolean;
}

export interface ApplicationForm {
    application: Application;
    applications: Array<Application>;
    environments: Array<Environment>;
    stages: Array<Stage>;
}

export interface EnvironmentFilter {
    stage: Stage;
    title: string;
}
export interface EnvironmentList {
    environments: Array<Environment>;
    filters: EnvironmentFilter;
    loading: boolean;
    stages: Array<Stage>;
}

export interface EnvironmentName {
    folderId: string | null;
    stageTitle: string;
    title: string;
}

export interface EnvironmentEdit {
    envId: string;
    folderId: string | null;
}

export interface EnvironmentForm {
    environmentModel: Environment;
    environments: Array<Environment>;
    saveEnabled: boolean;
}

export interface LabelsState {
    labelList: Array<Label>;
}

export interface StageState {
    stageList: Array<Stage>;
}

export interface ScheduleInitHeader {
    applications: Array<Application>;
    labels: Array<Label>;
    stages: Array<Stage>;
}
