package com.xebialabs.xlrelease.environments.repository.sql.persistence.data

import com.xebialabs.xlrelease.environments.repository.sql.persistence.ResultSetExtension
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import org.springframework.jdbc.core.ResultSetExtractor

import java.sql.ResultSet
import java.util.Date
import scala.collection.mutable

sealed case class EnvironmentReservationRow(
                                             id: CiId,
                                             from: Date,
                                             to: Date,
                                             note: String,
                                             environmentId: CiId,
                                             applicationIds: Vector[CiId]
                                           )

object EnvironmentReservationRow {
    private sealed case class EnvironmentReservationSearchRow(id: CiId, from: Date, to: Date, note: String)

  //noinspection ScalaStyle
  def reservationResultSetExtractor: ResultSetExtractor[Option[EnvironmentReservationRow]] = rs => {
    if(rs.next()) {
      val appIdsMap = mutable.Set.empty[CiId]
      val row = mapEnvironmentReservationSearchRow(rs)
      val envId = rs.getCiId(ColumnAliases.Environments.ID)
      if (rs.getCiId(ColumnAliases.Applications.ID) != null || rs.getCiId(ColumnAliases.EnvLabels.ID) != null) {
        do {
          if (rs.getCiId(ColumnAliases.Applications.ID) != null) {
            val appId = rs.getCiId(ColumnAliases.Applications.ID)
            appIdsMap += appId
          }
        } while (rs.next())
      }
      Some(EnvironmentReservationRow(
        row.id,
        row.from,
        row.to,
        row.note,
        envId,
        appIdsMap.toVector)
      )
    } else {
      None
    }
  }

  val reservationSearchResultSetExtractor: ResultSetExtractor[Map[CiId, Seq[EnvironmentReservationRow]]] = rs => {
    // Search row: | Environment | Stage | Label | Reservation | Application |
    // [
    //   Reservation -> Environment -> Stage
    //                              -> [Label]
    //               -> [Application]
    // ]
    val envToEnvResMapMap = mutable.Map.empty[CiId, mutable.Map[String, EnvironmentReservationSearchRow]]
    val resToAppIdsMap = mutable.Map.empty[String, mutable.Set[CiId]]

    while (rs.next()) {
      val envId = rs.getCiId(ColumnAliases.Environments.ID)//mapEnvironmentRow(rs, envMap, envToLabelsMap)
      val resMap = envToEnvResMapMap.getOrElseUpdate(envId, mutable.Map.empty[String, EnvironmentReservationSearchRow])
      if (rs.getCiId(ColumnAliases.EnvReservations.ID) != null) {
        val resId = rs.getCiId(ColumnAliases.EnvReservations.ID)
        resMap.getOrElseUpdate(resId,
          mapEnvironmentReservationSearchRow(rs))

        if (rs.getCiId(ColumnAliases.Applications.ID) != null) {
          val appId = rs.getCiId(ColumnAliases.Applications.ID)
          resToAppIdsMap.getOrElseUpdate(resId, mutable.Set.empty) += appId
        }

      }

    }

    envToEnvResMapMap.view.map { case (envId, resMap) =>
      envId -> resMap.view.map { case (resId, res) =>
        EnvironmentReservationRow(
          res.id, res.from, res.to, res.note,
          envId, resToAppIdsMap.getOrElse(resId, Set.empty[CiId]).view.toVector
        )
      }.toSeq
    }.toMap
  }

  private def mapEnvironmentReservationSearchRow(rs: ResultSet) =
    EnvironmentReservationSearchRow(
      rs.getCiId(ColumnAliases.EnvReservations.ID),
      new Date(rs.getTimestamp(ColumnAliases.EnvReservations.START_DATE).getTime),
      new Date(rs.getTimestamp(ColumnAliases.EnvReservations.END_DATE).getTime),
      rs.getString(ColumnAliases.EnvReservations.NOTE))
}
