package com.xebialabs.xlrelease.environments.repository.sql

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.CiIdService

import java.sql.ResultSet
import scala.reflect.ClassTag

package object persistence {
  private val ID_ROOT: String = CONFIGURATION.getRootNodeName + "/environmentManagement"

  def createPersistedId[T: ClassTag](implicit ciIdService: CiIdService): String = {
    Ids.getName(ciIdService.getUniqueId(Type.valueOf(implicitly[ClassTag[T]].runtimeClass), ID_ROOT))
  }

  def toPersistedId(id: String): String = Ids.getName(id)

  def toDisplayId(id: String): String = ID_ROOT + "/" + Ids.getName(id)

  def alreadyExistsMessage(label: String, title: String, folderIdMaybe: Option[String]): String = {
    val message = s"$label with title '${title}' already exists"
    val folderOrGlobalMsg = folderIdMaybe.map(id => s" on folder '$id'").getOrElse(" on global level")
    s"$message$folderOrGlobalMsg"
  }

  implicit class ResultSetExtension(rs: ResultSet) {
    def getCiId(columnLabel: String): String = {
      val id = rs.getString(columnLabel)
      if (id == null) {
        null
      } else {
        toDisplayId(id)
      }
    }
  }

}
