import { Label } from '../../../application-list.types';
import { bigLabelsList, label5, label6, labels } from '../../environment/__mocks__/environment-list.mocks';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import LabelListTruncated from './label-list-truncated';
import React from 'react';
import LabelItem, { ComponentSize } from './label-item';
import { Popover } from 'antd';
import { shallow } from 'enzyme';

describe('Label list truncated', () => {
    let wrapper: ReactWrapper;

    const mount = (lbls: Array<Label> = labels) => {
        wrapper = mountWithTheme(<LabelListTruncated labels={lbls} />);
    };

    it('should render', () => {
        mount();
        expect(wrapper.find('.label-list')).toExist();
        expect(wrapper.find(LabelItem)).toExist();
        expect(wrapper.find(LabelItem)).toHaveLength(2);
        expect(wrapper.find(Popover)).not.toExist();
    });

    it('should render popover', () => {
        const initialState = [
            <LabelItem envLabel={label5} key={label5.id} size={ComponentSize.Small} />,
            <LabelItem envLabel={label6} key={label6.id} size={ComponentSize.Small} />,
        ];
        React.useState = jest.fn().mockReturnValue([initialState, {}]);
        const component = shallow(<LabelListTruncated labels={bigLabelsList} />);
        expect(component.find(Popover)).toExist();
    });
});
