package com.xebialabs.xlrelease.environments.repository

import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters
import com.xebialabs.xlrelease.domain.environments.{Environment, EnvironmentReservation}
import com.xebialabs.xlrelease.repository.Page

import java.util.Date

trait EnvironmentReservationRepository {
  def search(filters: ReservationFilters, page: Page): Map[Environment, Seq[EnvironmentReservation]]

  def findById(environmentReservationId: String): EnvironmentReservation

  def getAllForEnvironmentId(environmentId: String): Seq[EnvironmentReservation]

  def create(environmentReservation: EnvironmentReservation): EnvironmentReservation

  def update(environmentReservation: EnvironmentReservation): EnvironmentReservation

  def delete(environmentReservationId: String): Unit

  def existsByEnvironmentIdAndApplicationIdAndDate(environmentId: String, applicationId: String, date: Date): Boolean

  def findNearestComingByEnvironmentIdAndApplicationIdAndDate(environmentId: String, applicationId: String, date: Date): Option[Date]
}
