package com.xebialabs.xlrelease.environments.repository.sql.persistence.schema

import com.xebialabs.xlrelease.repository.sql.persistence
import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.{CiUid, Table}

object EnvironmentSchema {
  val TITLE_LENGTH: Int = persistence.INDEXED_VARCHAR_LENGTH
  val DESCRIPTION_LENGTH: Int = persistence.LONG_VARCHAR_LENGTH

  object ENVIRONMENTS extends Table("XLR_ENVIRONMENTS") {
    val CI_UID = "CI_UID"
    val ID = "ID"
    val TITLE = "TITLE"
    val DESCRIPTION = "DESCRIPTION"
    val ENV_STAGE_UID = "ENV_STAGE_UID"
  }

  object ENV_TO_LABEL extends Table("XLR_ENV_TO_LABEL") {
    val ENVIRONMENT_UID = "ENVIRONMENT_UID"
    val LABEL_UID = "LABEL_UID"
  }

  case class EnvironmentRow(ciUid: CiUid, id: CiId, title: String, description: String, environmentStageUid: CiUid)
}
