package com.xebialabs.xlrelease.builder

import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel

object EnvironmentLabelBuilder {
  def newLabel: EnvironmentLabelBuilder = new EnvironmentLabelBuilder
}

class EnvironmentLabelBuilder {
  private var id: String = _
  private var title: String = _
  private var color: String = _

  def withId(id: String): EnvironmentLabelBuilder = {
    this.id = id
    this
  }

  def withTitle(title: String): EnvironmentLabelBuilder = {
    this.title = title
    this
  }

  def withColor(color: String): EnvironmentLabelBuilder = {
    this.color = color
    this
  }

  def build: EnvironmentLabel = {
    val label = new EnvironmentLabel
    label.setId(id)
    label.setTitle(title)
    if (color != null) {
      label.setColor(color)
    } else {
      label.setColor("#ff0000")
    }
    label
  }
}
