/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.EnvironmentReservationPersistence;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.ColumnAliases$Environments$;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentsWithReservationsSqlBuilder;
import com.xebialabs.xlrelease.environments.repository.sql.persistence.builder.EnvironmentsWithReservationsSqlBuilder$;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\t\u0013\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\u0019a\u000b\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005Y!AA\t\u0001BC\u0002\u0013\rQ\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003G\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011a\u0003!\u0011!Q\u0001\neCQ\u0001\u0018\u0001\u0005\u0002uCQ\u0001 \u0001\u0005BuDq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\ty\f\u0001C!\u0003\u0003\u00141eU9m\u000b:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005U1\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011q\u0003G\u0001\rK:4\u0018N]8o[\u0016tGo\u001d\u0006\u00033i\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005ma\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0012aA2p[\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003QI!!\u000b\u000b\u0003A\u0015sg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\bI&\fG.Z2u+\u0005a\u0003CA\u0017A\u001d\tqSH\u0004\u00020w9\u0011\u0001'\u000f\b\u0003car!AM\u001c\u000f\u0005M2T\"\u0001\u001b\u000b\u0005Ur\u0012A\u0002\u001fs_>$h(C\u0001\u001e\u0013\tYB$\u0003\u0002\u001a5%\u0011!\bG\u0001\u0003I\nL!a\u0005\u001f\u000b\u0005iB\u0012B\u0001 @\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003'qJ!!\u0011\"\u0003\u000f\u0011K\u0017\r\\3di*\u0011ahP\u0001\tI&\fG.Z2uA\u0005Y1-[%e'\u0016\u0014h/[2f+\u00051\u0005CA$K\u001b\u0005A%BA%\u0019\u0003\u001d\u0019XM\u001d<jG\u0016L!a\u0013%\u0003\u0017\rK\u0017\nZ*feZL7-Z\u0001\rG&LEmU3sm&\u001cW\rI\u0001\u0016CB\u0004H.[2bi&|gNU3q_NLGo\u001c:z!\t9s*\u0003\u0002Q)\t)\u0012\t\u001d9mS\u000e\fG/[8o%\u0016\u0004xn]5u_JL\u0018AF3om&\u0014xN\\7f]R\u0004VM]:jgR,gnY3\u0011\u0005M3V\"\u0001+\u000b\u0005U\u0013\u0012a\u00039feNL7\u000f^3oG\u0016L!a\u0016+\u0003-\u0015sg/\u001b:p]6,g\u000e\u001e)feNL7\u000f^3oG\u0016\f\u0011%\u001a8wSJ|g.\\3oiJ+7/\u001a:wCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\"a\u0015.\n\u0005m#&!I#om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0002\u001fj]&$h\bF\u0001_)\u0019y\u0016\r^;woB\u0011\u0001\rA\u0007\u0002%!)!\u0006\u0003a\u0002Y!\"\u0011mY9s!\t!w.D\u0001f\u0015\t1w-\u0001\u0006b]:|G/\u0019;j_:T!\u0001[5\u0002\u000f\u0019\f7\r^8ss*\u0011!n[\u0001\u0006E\u0016\fgn\u001d\u0006\u0003Y6\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002]\u0006\u0019qN]4\n\u0005A,'!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005\u0019\u0018a\u0006=meJ+\u0007o\\:ji>\u0014\u0018pU9m\t&\fG.Z2u\u0011\u0015!\u0005\u0002q\u0001G\u0011\u0015i\u0005\u00021\u0001O\u0011\u0015\t\u0006\u00021\u0001S\u0011\u0015A\u0006\u00021\u0001ZQ\tA\u0011\u0010\u0005\u0002eu&\u001110\u001a\u0002\n\u0003V$xn^5sK\u0012\faa]3be\u000eDG#\u0002@\u00024\u0005-\u0003cB@\u0002\b\u00055\u00111\u0004\b\u0005\u0003\u0003\t\u0019\u0001\u0005\u00024E%\u0019\u0011Q\u0001\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\u0003\u0003\u00075\u000b\u0007OC\u0002\u0002\u0006\t\u0002B!a\u0004\u0002\u00185\u0011\u0011\u0011\u0003\u0006\u0004/\u0005M!bAA\u000b1\u00051Am\\7bS:LA!!\u0007\u0002\u0012\tYQI\u001c<je>tW.\u001a8u!\u0019\ti\"a\n\u0002.9!\u0011qDA\u0012\u001d\r\u0019\u0014\u0011E\u0005\u0002G%\u0019\u0011Q\u0005\u0012\u0002\u000fA\f7m[1hK&!\u0011\u0011FA\u0016\u0005\r\u0019V-\u001d\u0006\u0004\u0003K\u0011\u0003\u0003BA\b\u0003_IA!!\r\u0002\u0012\t1RI\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|g\u000eC\u0004\u00026%\u0001\r!a\u000e\u0002\u000f\u0019LG\u000e^3sgB!\u0011\u0011HA$\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012A\u00024jYR,'O\u0003\u0003\u0002B\u0005\r\u0013A\u0001<2\u0015\r\t)\u0005G\u0001\u0004CBL\u0017\u0002BA%\u0003w\u0011!CU3tKJ4\u0018\r^5p]\u001aKG\u000e^3sg\"9\u0011QJ\u0005A\u0002\u0005=\u0013\u0001\u00029bO\u0016\u0004B!!\u0015\u0002V5\u0011\u00111\u000b\u0006\u0003+aIA!a\u0016\u0002T\t!\u0001+Y4fQ\rI\u00111\f\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011M \u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003K\nyF\u0001\u0006JgJ+\u0017\rZ(oYf\f\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0005\u0003[\tY\u0007C\u0004\u0002n)\u0001\r!a\u001c\u00021\u0015tg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:LE\rE\u0002\u0000\u0003cJA!a\u001d\u0002\f\t11\u000b\u001e:j]\u001eD3ACA.\u0003Y9W\r^!mY\u001a{'/\u00128wSJ|g.\\3oi&#G\u0003BA\u000e\u0003wBq!! \f\u0001\u0004\ty'A\u0007f]ZL'o\u001c8nK:$\u0018\n\u001a\u0015\u0004\u0017\u0005m\u0013AB2sK\u0006$X\r\u0006\u0003\u0002.\u0005\u0015\u0005bBAD\u0019\u0001\u0007\u0011QF\u0001\u0017K:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]\u00061Q\u000f\u001d3bi\u0016$B!!\f\u0002\u000e\"9\u0011qQ\u0007A\u0002\u00055\u0012A\u00023fY\u0016$X\r\u0006\u0003\u0002\u0014\u0006e\u0005cA\u0011\u0002\u0016&\u0019\u0011q\u0013\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003[r\u0001\u0019AA8\u00031*\u00070[:ug\nKXI\u001c<je>tW.\u001a8u\u0013\u0012\fe\u000eZ!qa2L7-\u0019;j_:LE-\u00118e\t\u0006$X\r\u0006\u0005\u0002 \u0006\u0015\u0016qUAV!\r\t\u0013\u0011U\u0005\u0004\u0003G\u0013#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003{z\u0001\u0019AA8\u0011\u001d\tIk\u0004a\u0001\u0003_\nQ\"\u00199qY&\u001c\u0017\r^5p]&#\u0007bBAW\u001f\u0001\u0007\u0011qV\u0001\u0005I\u0006$X\r\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003s\u000bAA[1wC&!\u0011QXAZ\u0005\u0011!\u0015\r^3\u0002o\u0019Lg\u000e\u001a(fCJ,7\u000f^\"p[&twMQ=F]ZL'o\u001c8nK:$\u0018\nZ!oI\u0006\u0003\b\u000f\\5dCRLwN\\%e\u0003:$G)\u0019;f)!\t\u0019-!3\u0002L\u00065\u0007#B\u0011\u0002F\u0006=\u0016bAAdE\t1q\n\u001d;j_:Dq!! \u0011\u0001\u0004\ty\u0007C\u0004\u0002*B\u0001\r!a\u001c\t\u000f\u00055\u0006\u00031\u0001\u00020\"\u001a\u0001!!5\u0011\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6l\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u00037\f)N\u0001\u0006SKB|7/\u001b;pefD3\u0001AAp!\u0011\ti&!9\n\t\u0005\r\u0018q\f\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlEnvironmentReservationRepository
implements EnvironmentReservationRepository {
    private final SqlBuilder.Dialect dialect;
    private final CiIdService ciIdService;
    private final EnvironmentReservationPersistence environmentReservationPersistence;

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    @IsReadOnly
    public Map<Environment, Seq<EnvironmentReservation>> search(ReservationFilters filters, Page page) {
        EnvironmentsWithReservationsSqlBuilder query = EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply(EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).orderBy(ColumnAliases$Environments$.MODULE$.CI_UID()).limitAndOffset(page.resultsPerPage(), page.offset());
        Option$.MODULE$.apply((Object)filters).foreach((Function1 & Serializable)f -> {
            SqlEnvironmentReservationRepository.$anonfun$search$1(query, f);
            return BoxedUnit.UNIT;
        });
        return this.environmentReservationPersistence.search(query.build());
    }

    @Override
    @IsReadOnly
    public EnvironmentReservation findById(String environmentReservationId) {
        return (EnvironmentReservation)this.environmentReservationPersistence.findById(environmentReservationId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Environment reservation [" + environmentReservationId + "] not found", new Object[0]);
        });
    }

    @Override
    @IsReadOnly
    public Seq<EnvironmentReservation> getAllForEnvironmentId(String environmentId) {
        Environment tmpEnvironment = (Environment)new Environment().getType().getDescriptor().newInstance(environmentId);
        EnvironmentsWithReservationsSqlBuilder query = EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply(EnvironmentsWithReservationsSqlBuilder$.MODULE$.apply$default$1(), this.dialect()).withEnvironmentId(environmentId);
        return (Seq)this.environmentReservationPersistence.search(query.build()).getOrElse((Object)tmpEnvironment, (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    @Override
    public EnvironmentReservation create(EnvironmentReservation environmentReservation) {
        String resId = this.environmentReservationPersistence.insert(environmentReservation);
        return this.findById(resId);
    }

    @Override
    public EnvironmentReservation update(EnvironmentReservation environmentReservation) {
        this.environmentReservationPersistence.update(environmentReservation);
        return this.findById(environmentReservation.getId());
    }

    @Override
    public void delete(String environmentReservationId) {
        this.environmentReservationPersistence.delete(environmentReservationId);
    }

    @Override
    public boolean existsByEnvironmentIdAndApplicationIdAndDate(String environmentId, String applicationId, Date date) {
        return this.environmentReservationPersistence.exists(environmentId, applicationId, date);
    }

    @Override
    public Option<Date> findNearestComingByEnvironmentIdAndApplicationIdAndDate(String environmentId, String applicationId, Date date) {
        return this.environmentReservationPersistence.findNearestComing(environmentId, applicationId, date);
    }

    public static final /* synthetic */ void $anonfun$search$1(EnvironmentsWithReservationsSqlBuilder query$1, ReservationFilters f) {
        Option$.MODULE$.apply((Object)f.getEnvironmentTitle()).foreach((Function1 & Serializable)title -> query$1.withEnvironmentTitleLike((String)title));
        Option$.MODULE$.apply((Object)f.getStages()).foreach((Function1 & Serializable)stages -> query$1.withStageTitles((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(stages).asScala()));
        Option$.MODULE$.apply((Object)f.getApplications()).foreach((Function1 & Serializable)apps -> query$1.withApplicationTitles((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(apps).asScala()));
        Option$.MODULE$.apply((Object)f.getLabels()).foreach((Function1 & Serializable)labels -> query$1.withLabelTitles((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(labels).asScala()));
        Option$.MODULE$.apply((Object)f.getFrom()).foreach((Function1 & Serializable)date -> query$1.from((Date)date));
        Option$.MODULE$.apply((Object)f.getTo()).foreach((Function1 & Serializable)date -> query$1.to((Date)date));
    }

    @Autowired
    public SqlEnvironmentReservationRepository(@Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, CiIdService ciIdService, ApplicationRepository applicationRepository, EnvironmentPersistence environmentPersistence, EnvironmentReservationPersistence environmentReservationPersistence) {
        this.dialect = dialect;
        this.ciIdService = ciIdService;
        this.environmentReservationPersistence = environmentReservationPersistence;
    }
}

