package com.xebialabs.xlrelease.environments.repository

import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters
import com.xebialabs.xlrelease.domain.environments.Environment
import com.xebialabs.xlrelease.repository.Page

trait EnvironmentRepository {

  def searchEnvironments(environmentFilters: EnvironmentFilters, page: Page): Seq[Environment]

  def findEnvironmentById(environmentId: String): Environment

  def findEnvironmentByTitle(environmentTitle: String): Environment

  def createEnvironment(environment: Environment): Environment

  def updateEnvironment(environment: Environment): Environment

  def deleteEnvironment(environmentId: String): Unit
}
