/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003U\u0001\u0011\u0005Q\u000bC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAA\u0001\u0011%\u00111\u0011\u0002\u001e\u000b:4\u0018N]8o[\u0016tGOU3tKJ4\u0018\r^5p]N+'O^5dK*\u00111\u0003F\u0001\bg\u0016\u0014h/[2f\u0015\t)b#\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\u00181\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00033i\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003m\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006g24GG\u001b\u0006\u0002S\u0005AqM]5{u2,G-\u0003\u0002,M\t9Aj\\4hS:<\u0017\u0001I3om&\u0014xN\\7f]R\u0014Vm]3sm\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00023_\t\u0001SI\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|gNU3q_NLGo\u001c:z\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005U2T\"\u0001\n\n\u0005]\u0012\"AE!qa2L7-\u0019;j_:\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003uuj\u0011a\u000f\u0006\u0003yY\ta!\u001a<f]R\u001c\u0018B\u0001 <\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u00135\t\u0012\t\u0003k\u0001AQ\u0001\f\u0003A\u00025BQa\r\u0003A\u0002QBQ\u0001\u000f\u0003A\u0002eB#\u0001\u0002$\u0011\u0005\u001d\u0013V\"\u0001%\u000b\u0005%S\u0015AC1o]>$\u0018\r^5p]*\u00111\nT\u0001\bM\u0006\u001cGo\u001c:z\u0015\tie*A\u0003cK\u0006t7O\u0003\u0002P!\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001R\u0003\ry'oZ\u0005\u0003'\"\u0013\u0011\"Q;u_^L'/\u001a3\u0002%M,\u0017M]2i%\u0016\u001cXM\u001d<bi&|gn\u001d\u000b\u0003-.\u0004Ba\u0016/_K6\t\u0001L\u0003\u0002Z5\u0006!Q\u000f^5m\u0015\u0005Y\u0016\u0001\u00026bm\u0006L!!\u0018-\u0003\u00075\u000b\u0007\u000f\u0005\u0002`G6\t\u0001M\u0003\u0002\u0016C*\u0011!MF\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0011\u0004'aC#om&\u0014xN\\7f]R\u00042a\u00164i\u0013\t9\u0007L\u0001\u0003MSN$\bCA0j\u0013\tQ\u0007M\u0001\fF]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o\u0011\u0015aW\u00011\u0001n\u0003\u001d1\u0017\u000e\u001c;feN\u0004\"A\\;\u000e\u0003=T!\u0001]9\u0002\r\u0019LG\u000e^3s\u0015\t\u00118/\u0001\u0002wc)\u0011AOF\u0001\u0004CBL\u0017B\u0001<p\u0005I\u0011Vm]3sm\u0006$\u0018n\u001c8GS2$XM]:)\u0005\u0015A\bCA=\u0000\u001b\u0005Q(BA%|\u0015\taX0A\u0004nKR\u0014\u0018nY:\u000b\u0005yT\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0007\u0005\u0005!PA\u0003US6,G-A\ngS:$'+Z:feZ\fG/[8o\u0005fLE\rF\u0002i\u0003\u000fAq!!\u0003\u0007\u0001\u0004\tY!\u0001\rf]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o\u0013\u0012\u0004B!!\u0004\u0002\u001c9!\u0011qBA\f!\r\t\t\u0002I\u0007\u0003\u0003'Q1!!\u0006\u001d\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0004\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\ti\"a\b\u0003\rM#(/\u001b8h\u0015\r\tI\u0002\t\u0015\u0003\ra\fadZ3u%\u0016\u001cXM\u001d<bi&|gn\u001d\"z\u000b:4\u0018N]8o[\u0016tG/\u00133\u0015\u0007\u0015\f9\u0003C\u0004\u0002*\u001d\u0001\r!a\u0003\u0002\u001b\u0015tg/\u001b:p]6,g\u000e^%eQ\t9\u00010A\tde\u0016\fG/\u001a*fg\u0016\u0014h/\u0019;j_:$2\u0001[A\u0019\u0011\u0019\t\u0019\u0004\u0003a\u0001Q\u00061RM\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|g\u000e\u000b\u0002\tq\u0006\tR\u000f\u001d3bi\u0016\u0014Vm]3sm\u0006$\u0018n\u001c8\u0015\u0007!\fY\u0004\u0003\u0004\u00024%\u0001\r\u0001\u001b\u0015\u0003\u0013a\f\u0011\u0003Z3mKR,'+Z:feZ\fG/[8o)\u0011\t\u0019%!\u0013\u0011\u0007}\t)%C\u0002\u0002H\u0001\u0012A!\u00168ji\"9\u0011\u0011\u0002\u0006A\u0002\u0005-\u0001F\u0001\u0006y\u0003E)\u00070[:ugJ+7/\u001a:wCRLwN\u001c\u000b\u0007\u0003#\n9&!\u0017\u0011\u0007}\t\u0019&C\u0002\u0002V\u0001\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002*-\u0001\r!a\u0003\t\u000f\u0005m3\u00021\u0001\u0002\f\u0005i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012D#a\u0003=\u000219,\u0017M]3ti\u000e{W.\u001b8h%\u0016\u001cXM\u001d<bi&|g\u000e\u0006\u0004\u0002d\u0005%\u00141\u000e\t\u0004/\u0006\u0015\u0014bAA41\n!A)\u0019;f\u0011\u001d\tI\u0003\u0004a\u0001\u0003\u0017Aq!a\u0017\r\u0001\u0004\tY\u0001\u000b\u0002\rq\u0006Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002D\u0005M\u0004BBA\u001a\u001b\u0001\u0007\u0001.A\u0007wC2LG-\u0019;f\t\u0006$Xm\u001d\u000b\u0005\u0003\u0007\nI\b\u0003\u0004\u000249\u0001\r\u0001[\u0001\rm\u0006d\u0017\u000eZ1uK:{G/\u001a\u000b\u0005\u0003\u0007\ny\b\u0003\u0004\u00024=\u0001\r\u0001[\u0001\u0015m\u0006d\u0017\u000eZ1uK\u0006\u0003\b\u000f\\5dCRLwN\\:\u0015\t\u0005\r\u0013Q\u0011\u0005\u0007\u0003g\u0001\u0002\u0019\u00015)\u0007\u0001\tI\t\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\tyIT\u0001\u000bgR,'/Z8usB,\u0017\u0002BAJ\u0003\u001b\u0013qaU3sm&\u001cW\r")
public class EnvironmentReservationService
implements Logging {
    private final EnvironmentReservationRepository environmentReservationRepository;
    private final ApplicationService applicationService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentReservationService environmentReservationService = this;
        synchronized (environmentReservationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public java.util.Map<Environment, List<EnvironmentReservation>> searchReservations(ReservationFilters filters) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)this.environmentReservationRepository.search(filters, package$.MODULE$.defaultPage()).view().mapValues((Function1 & Serializable)x$1 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)x$1).asJava()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    @Timed
    public EnvironmentReservation findReservationById(String environmentReservationId) {
        return this.environmentReservationRepository.findById(environmentReservationId);
    }

    @Timed
    public List<EnvironmentReservation> getReservationsByEnvironmentId(String environmentId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.environmentReservationRepository.getAllForEnvironmentId(environmentId)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation createReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable)() -> "Creating a new environment reservation");
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.create(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationCreatedEvent(reservation));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation updateReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable)() -> "Updating environment reservation [" + environmentReservation + "]");
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.update(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationUpdatedEvent(reservation));
        return var2_2;
    }

    @Timed
    public void deleteReservation(String environmentReservationId) {
        this.logger().debug((Function0 & Serializable)() -> "Deleting environment reservation [" + environmentReservationId + "]");
        EnvironmentReservation reservation = this.environmentReservationRepository.findById(environmentReservationId);
        this.environmentReservationRepository.delete(environmentReservationId);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationDeletedEvent(reservation));
    }

    @Timed
    public boolean existsReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable)() -> "Checking reservation for environmentId [" + environmentId + "] and applicationId [" + applicationId + "]");
        return this.environmentReservationRepository.existsByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date());
    }

    @Timed
    public Date nearestComingReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable)() -> "Checking nearest coming reservation for environmentId [" + environmentId + "] and applicationId [" + applicationId + "]");
        return (Date)this.environmentReservationRepository.findNearestComingByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void validate(EnvironmentReservation environmentReservation) {
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environmentReservation.getEnvironment()).exists((Function1 & Serializable)env -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationService.$anonfun$validate$1(env))), (String)"Environment ID is required", (Object[])new Object[0]);
        this.validateDates(environmentReservation);
        this.validateNote(environmentReservation);
        this.validateApplications(environmentReservation);
    }

    private void validateDates(EnvironmentReservation environmentReservation) {
        Date startDate = environmentReservation.getStartDate();
        Date endDate = environmentReservation.getEndDate();
        Checks.checkArgument((startDate != null ? 1 : 0) != 0, (String)"Start date is required", (Object[])new Object[0]);
        Checks.checkArgument((endDate != null ? 1 : 0) != 0, (String)"End date is required", (Object[])new Object[0]);
        Checks.checkArgument((boolean)startDate.before(endDate), (String)"Start date must be before the end date", (Object[])new Object[0]);
    }

    private void validateNote(EnvironmentReservation environmentReservation) {
        block0: {
            if (environmentReservation.getNote() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getNote()), (String)"Note cannot be blank", (Object[])new Object[0]);
        }
    }

    private void validateApplications(EnvironmentReservation environmentReservation) {
        if (!CollectionUtils.isEmpty((Collection)environmentReservation.getApplications())) {
            scala.collection.immutable.Set allowedAppIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.applicationService.getApplicationsDeployableOnEnvironment(environmentReservation.getEnvironment().getId())).asScala().map((Function1 & Serializable)x$2 -> x$2.getId())).toSet();
            scala.collection.immutable.Set givenAppIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(environmentReservation.getApplications()).asScala().map((Function1 & Serializable)x$3 -> x$3.getId())).toSet();
            scala.collection.immutable.Set diff = (scala.collection.immutable.Set)givenAppIds.diff((Set)allowedAppIds);
            if (diff.nonEmpty()) {
                Tuple2 tuple2 = diff.splitAt(10);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                scala.collection.immutable.Set first10 = (scala.collection.immutable.Set)tuple2._1();
                scala.collection.immutable.Set rest = (scala.collection.immutable.Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)first10, (Object)rest);
                Tuple2 tuple23 = tuple22;
                scala.collection.immutable.Set first102 = (scala.collection.immutable.Set)tuple23._1();
                scala.collection.immutable.Set rest2 = (scala.collection.immutable.Set)tuple23._2();
                throw new Checks.IncorrectArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |The following applications are not deployable on environment [" + environmentReservation.getEnvironment().getTitle() + " - " + environmentReservation.getEnvironment().getId() + "]:\n             |[" + first102.mkString(", ") + "] " + (rest2.nonEmpty() ? ", and more" : BoxedUnit.UNIT) + "\n             |")), new Object[0]);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(Environment env) {
        return StringUtils.hasText((String)env.getId());
    }

    @Autowired
    public EnvironmentReservationService(EnvironmentReservationRepository environmentReservationRepository, ApplicationService applicationService, XLReleaseEventBus eventBus) {
        this.environmentReservationRepository = environmentReservationRepository;
        this.applicationService = applicationService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

