/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ApplicationFilters;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.ApplicationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.ApplicationRepository;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011)\u0019!C\u0001O!Aa\u0006\u0001B\u0001B\u0003%\u0001\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0003l\u0001\u0011\u0005A\u000eC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0002\u0013\u0003B\u0004H.[2bi&|gnU3sm&\u001cWM\u0003\u0002\u000f\u001f\u000591/\u001a:wS\u000e,'B\u0001\t\u0012\u00031)gN^5s_:lWM\u001c;t\u0015\t\u00112#A\u0005yYJ,G.Z1tK*\u0011A#F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AF\u0001\u0004G>l7\u0001A\n\u0003\u0001e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0017!F1qa2L7-\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003C\u0011j\u0011A\t\u0006\u0003G=\t!B]3q_NLGo\u001c:z\u0013\t)#EA\u000bBaBd\u0017nY1uS>t'+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN,\u0012\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003WE\ta!\u001a<f]R\u001c\u0018BA\u0017+\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtDcA\u00194iA\u0011!\u0007A\u0007\u0002\u001b!)q\u0004\u0002a\u0001A!)a\u0005\u0002a\u0001Q!\u0012AA\u000e\t\u0003o\tk\u0011\u0001\u000f\u0006\u0003si\n!\"\u00198o_R\fG/[8o\u0015\tYD(A\u0004gC\u000e$xN]=\u000b\u0005ur\u0014!\u00022fC:\u001c(BA A\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A!\u0002\u0007=\u0014x-\u0003\u0002Dq\tI\u0011)\u001e;po&\u0014X\rZ\u0001\u0013g\u0016\f'o\u00195BaBd\u0017nY1uS>t7\u000f\u0006\u0002G+B\u0019q\t\u0014(\u000e\u0003!S!!\u0013&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0017\u0006!!.\u0019<b\u0013\ti\u0005J\u0001\u0003MSN$\bCA(T\u001b\u0005\u0001&B\u0001\tR\u0015\t\u0011\u0016#\u0001\u0004e_6\f\u0017N\\\u0005\u0003)B\u00131\"\u00119qY&\u001c\u0017\r^5p]\")a+\u0002a\u0001/\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\r&dG/\u001a:t!\tAv,D\u0001Z\u0015\tQ6,\u0001\u0004gS2$XM\u001d\u0006\u00039v\u000b!A^\u0019\u000b\u0005y\u000b\u0012aA1qS&\u0011\u0001-\u0017\u0002\u0013\u0003B\u0004H.[2bi&|gNR5mi\u0016\u00148\u000f\u000b\u0002\u0006EB\u00111-[\u0007\u0002I*\u0011\u0011(\u001a\u0006\u0003M\u001e\fq!\\3ue&\u001c7O\u0003\u0002i+\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002kI\n)A+[7fI\u0006\u0019b-\u001b8e\u0003B\u0004H.[2bi&|gNQ=JIR\u0011a*\u001c\u0005\u0006]\u001a\u0001\ra\\\u0001\u000eCB\u0004H.[2bi&|g.\u00133\u0011\u0005A<hBA9v!\t\u00118$D\u0001t\u0015\t!x#\u0001\u0004=e>|GOP\u0005\u0003mn\ta\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011ao\u0007\u0015\u0003\r\t\f\u0011c\u0019:fCR,\u0017\t\u001d9mS\u000e\fG/[8o)\tqU\u0010C\u0003\u007f\u000f\u0001\u0007a*A\u0006baBd\u0017nY1uS>t\u0007FA\u0004c\u0003E)\b\u000fZ1uK\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0004\u001d\u0006\u0015\u0001\"\u0002@\t\u0001\u0004q\u0005F\u0001\u0005c\u0003E!W\r\\3uK\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002\u001b\u0003\u001fI1!!\u0005\u001c\u0005\u0011)f.\u001b;\t\u000b9L\u0001\u0019A8)\u0005%\u0011\u0017AJ4fi\u0006\u0003\b\u000f\\5dCRLwN\\:EKBdw._1cY\u0016|e.\u00128wSJ|g.\\3oiR\u0019a)a\u0007\t\r\u0005u!\u00021\u0001p\u00035)gN^5s_:lWM\u001c;JI\"\u0012!BY\u0001\u000em\u0006d\u0017\u000eZ1uKRKG\u000f\\3\u0015\t\u00055\u0011Q\u0005\u0005\u0006}.\u0001\rA\u0014\u0015\u0004\u0001\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=b(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\r\u0002.\t91+\u001a:wS\u000e,\u0007")
public class ApplicationService {
    private final ApplicationRepository applicationRepository;
    private final XLReleaseEventBus eventBus;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @Timed
    public List<Application> searchApplications(ApplicationFilters applicationFilters) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.searchApplications(applicationFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Application findApplicationById(String applicationId) {
        Application application = this.applicationRepository.findApplicationById(applicationId);
        return application;
    }

    @Timed
    public Application createApplication(Application application) {
        this.validateTitle(application);
        Application createdApplication = this.applicationRepository.createApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationCreatedEvent(createdApplication));
        return createdApplication;
    }

    @Timed
    public Application updateApplication(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validateTitle(application);
        Application updatedApplication = this.applicationRepository.updateApplication(application);
        this.eventBus().publish((XLReleaseEvent)new ApplicationUpdatedEvent(updatedApplication));
        return updatedApplication;
    }

    @Timed
    public void deleteApplication(String applicationId) {
        Application application = this.applicationRepository.findApplicationById(applicationId);
        this.applicationRepository.deleteApplication(applicationId);
        this.eventBus().publish((XLReleaseEvent)new ApplicationDeletedEvent(application));
    }

    @Timed
    public List<Application> getApplicationsDeployableOnEnvironment(String environmentId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.applicationRepository.getApplicationsDeployableOnEnvironment(environmentId)).asJava();
    }

    private void validateTitle(Application application) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)application.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    @Autowired
    public ApplicationService(ApplicationRepository applicationRepository, XLReleaseEventBus eventBus) {
        this.applicationRepository = applicationRepository;
        this.eventBus = eventBus;
    }
}

