/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.api.v1.EnvironmentApi;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentForm;
import com.xebialabs.xlrelease.api.v1.views.BaseApplicationView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentReservationView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentView;
import com.xebialabs.xlrelease.domain.environments.Application;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentReservationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EnvironmentApiImpl
implements EnvironmentApi {
    private EnvironmentService environmentService;
    private EnvironmentSecurity environmentSecurity;
    private ApplicationService applicationService;
    private EnvironmentReservationService environmentReservationService;

    @Autowired
    public EnvironmentApiImpl(EnvironmentService environmentService, EnvironmentSecurity environmentSecurity, ApplicationService applicationService, EnvironmentReservationService environmentReservationService) {
        this.environmentService = environmentService;
        this.environmentSecurity = environmentSecurity;
        this.applicationService = applicationService;
        this.environmentReservationService = environmentReservationService;
    }

    @Timed
    public EnvironmentView createEnvironment(EnvironmentForm environmentForm) {
        this.environmentSecurity.checkCreate();
        return EnvironmentView.fromEnvironment((Environment)this.environmentService.createEnvironment(environmentForm.toEnvironment()));
    }

    @Timed
    public EnvironmentView getEnvironment(String environmentId) {
        this.environmentSecurity.checkView();
        return EnvironmentView.fromEnvironment((Environment)this.environmentService.findEnvironmentById(environmentId));
    }

    @Timed
    public EnvironmentView updateEnvironment(String environmentId, EnvironmentForm environmentForm) {
        this.environmentSecurity.checkEdit();
        Environment environment = environmentForm.toEnvironment();
        environment.setId(environmentId);
        return EnvironmentView.fromEnvironment((Environment)this.environmentService.updateEnvironment(environment));
    }

    @Timed
    public List<EnvironmentView> searchEnvironments(EnvironmentFilters environmentFilters) {
        this.environmentSecurity.checkView();
        return this.environmentService.searchEnvironments(environmentFilters).stream().map(EnvironmentView::fromEnvironment).collect(Collectors.toList());
    }

    @Timed
    public List<EnvironmentReservationView> getReservationsForEnvironment(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentReservationService.getReservationsByEnvironmentId(environmentId).stream().map(EnvironmentReservationView::fromEnvironmentReservation).collect(Collectors.toList());
    }

    @Timed
    public List<BaseApplicationView> getDeployableApplicationsForEnvironment(String environmentId) {
        this.environmentSecurity.checkView();
        return this.applicationService.getApplicationsDeployableOnEnvironment(environmentId).stream().map(BaseApplicationView::fromApplication).collect(Collectors.toList());
    }

    @Timed
    public void delete(String environmentId) {
        this.environmentSecurity.checkEdit();
        this.environmentService.deleteEnvironment(environmentId);
    }

    @Timed
    public Environment create(Environment environment) {
        this.environmentSecurity.checkCreate();
        return this.environmentService.createEnvironment(environment);
    }

    @Timed
    public Environment getById(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentService.findEnvironmentById(environmentId);
    }

    @Timed
    public Environment update(Environment environment) {
        this.environmentSecurity.checkEdit();
        return this.environmentService.updateEnvironment(environment);
    }

    @Timed
    public List<Environment> search(EnvironmentFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentService.searchEnvironments(filters);
    }

    @Timed
    public List<EnvironmentReservation> getReservations(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentReservationService.getReservationsByEnvironmentId(environmentId);
    }

    @Timed
    public List<Application> getDeployableApplications(String environmentId) {
        this.environmentSecurity.checkView();
        return this.applicationService.getApplicationsDeployableOnEnvironment(environmentId);
    }
}

