/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.api.v1.EnvironmentLabelApi;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentLabelForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentLabelView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.environments.service.EnvironmentLabelService;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EnvironmentLabelApiImpl
implements EnvironmentLabelApi {
    private EnvironmentLabelService environmentLabelService;
    private EnvironmentSecurity environmentSecurity;

    @Autowired
    public EnvironmentLabelApiImpl(EnvironmentLabelService environmentLabelService, EnvironmentSecurity environmentSecurity) {
        this.environmentLabelService = environmentLabelService;
        this.environmentSecurity = environmentSecurity;
    }

    @Timed
    public EnvironmentLabelView createLabel(EnvironmentLabelForm labelForm) {
        this.environmentSecurity.checkCreate();
        return EnvironmentLabelView.fromEnvironmentLabel((EnvironmentLabel)this.environmentLabelService.createLabel(labelForm.toLabel()));
    }

    @Timed
    public EnvironmentLabelView getLabelById(String environmentLabelId) {
        this.environmentSecurity.checkView();
        return EnvironmentLabelView.fromEnvironmentLabel((EnvironmentLabel)this.environmentLabelService.findLabelById(environmentLabelId));
    }

    @Timed
    public EnvironmentLabelView updateLabel(String environmentLabelId, EnvironmentLabelForm labelForm) {
        this.environmentSecurity.checkEdit();
        EnvironmentLabel label = labelForm.toLabel();
        label.setId(environmentLabelId);
        return EnvironmentLabelView.fromEnvironmentLabel((EnvironmentLabel)this.environmentLabelService.updateLabel(label));
    }

    @Timed
    public List<EnvironmentLabelView> searchLabels(EnvironmentLabelFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentLabelService.searchLabels(filters).stream().map(EnvironmentLabelView::fromEnvironmentLabel).collect(Collectors.toList());
    }

    @Timed
    public void delete(String environmentLabelId) {
        this.environmentSecurity.checkEdit();
        this.environmentLabelService.deleteLabel(environmentLabelId);
    }

    @Timed
    public EnvironmentLabel create(EnvironmentLabel environmentLabel) {
        this.environmentSecurity.checkCreate();
        return this.environmentLabelService.createLabel(environmentLabel);
    }

    @Timed
    public EnvironmentLabel getById(String id) {
        this.environmentSecurity.checkView();
        return this.environmentLabelService.findLabelById(id);
    }

    @Timed
    public EnvironmentLabel update(EnvironmentLabel environmentLabel) {
        this.environmentSecurity.checkEdit();
        return this.environmentLabelService.updateLabel(environmentLabel);
    }

    @Timed
    public List<EnvironmentLabel> search(EnvironmentLabelFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentLabelService.searchLabels(filters);
    }
}

