/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters;
import com.xebialabs.xlrelease.api.v1.form.EnvironmentLabelForm;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentLabelView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.environments.service.EnvironmentLabelService;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.rest.AllCILevels;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/environments/labels")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class EnvironmentLabelApi
implements ApiService {
    private EnvironmentLabelService environmentLabelService;
    private EnvironmentSecurity environmentSecurity;

    public String serviceName() {
        return "environmentLabelApi";
    }

    @Autowired
    public EnvironmentLabelApi(EnvironmentLabelService environmentLabelService, EnvironmentSecurity environmentSecurity) {
        this.environmentLabelService = environmentLabelService;
        this.environmentSecurity = environmentSecurity;
    }

    @POST
    @Timed
    public EnvironmentLabelView createLabel(EnvironmentLabelForm labelForm) {
        this.environmentSecurity.checkCreate();
        return EnvironmentLabelView.fromEnvironmentLabel(this.environmentLabelService.createLabel(labelForm.toLabel()));
    }

    @GET
    @Timed
    @Path(value="/{environmentLabelId:.*/EnvironmentLabel[^/]*}")
    public EnvironmentLabelView getLabelById(@PathParam(value="environmentLabelId") String environmentLabelId) {
        this.environmentSecurity.checkView();
        return EnvironmentLabelView.fromEnvironmentLabel(this.environmentLabelService.findLabelById(environmentLabelId));
    }

    @PUT
    @Timed
    @Path(value="/{environmentLabelId:.*/EnvironmentLabel[^/]*}")
    public EnvironmentLabelView updateLabel(@PathParam(value="environmentLabelId") String environmentLabelId, EnvironmentLabelForm labelForm) {
        this.environmentSecurity.checkEdit();
        EnvironmentLabel label = labelForm.toLabel();
        label.setId(environmentLabelId);
        return EnvironmentLabelView.fromEnvironmentLabel(this.environmentLabelService.updateLabel(label));
    }

    @POST
    @Timed
    @Path(value="/search")
    public List<EnvironmentLabelView> searchLabels(EnvironmentLabelFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentLabelService.searchLabels(filters).stream().map(EnvironmentLabelView::fromEnvironmentLabel).collect(Collectors.toList());
    }

    @DELETE
    @Timed
    @PublicApiMember
    @Path(value="/{environmentLabelId:.*/EnvironmentLabel[^/]*}")
    public void delete(@PathParam(value="environmentLabelId") String environmentLabelId) {
        this.environmentSecurity.checkEdit();
        this.environmentLabelService.deleteLabel(environmentLabelId);
    }

    @PublicApiMember
    @Timed
    public EnvironmentLabel create(EnvironmentLabel environmentLabel) {
        this.environmentSecurity.checkCreate();
        return this.environmentLabelService.createLabel(environmentLabel);
    }

    @PublicApiMember
    @Timed
    public EnvironmentLabel getById(String id) {
        this.environmentSecurity.checkView();
        return this.environmentLabelService.findLabelById(id);
    }

    @PublicApiMember
    @Timed
    public EnvironmentLabel update(EnvironmentLabel environmentLabel) {
        this.environmentSecurity.checkEdit();
        return this.environmentLabelService.updateLabel(environmentLabel);
    }

    @PublicApiMember
    @Timed
    public List<EnvironmentLabel> search(EnvironmentLabelFilters filters) {
        this.environmentSecurity.checkView();
        return this.environmentLabelService.searchLabels(filters);
    }
}

