/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.filter.ReservationFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationCreatedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationDeletedEvent;
import com.xebialabs.xlrelease.environments.events.EnvironmentReservationUpdatedEvent;
import com.xebialabs.xlrelease.environments.repository.EnvironmentReservationRepository;
import com.xebialabs.xlrelease.environments.service.ApplicationService;
import com.xebialabs.xlrelease.environments.service.EnvironmentService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\n\u0014\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\b\u0002!I!!#\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\niRI\u001c<je>tW.\u001a8u%\u0016\u001cXM\u001d<bi&|gnU3sm&\u001cWM\u0003\u0002\u0015+\u000591/\u001a:wS\u000e,'B\u0001\f\u0018\u00031)gN^5s_:lWM\u001c;t\u0015\tA\u0012$A\u0005yYJ,G.Z1tK*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)1\u000f\u001c45U*\t!&\u0001\u0005he&T(\u0010\\3e\u0013\tasEA\u0004M_\u001e<\u0017N\\4\u0002A\u0015tg/\u001b:p]6,g\u000e\u001e*fg\u0016\u0014h/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003_Ij\u0011\u0001\r\u0006\u0003cU\t!B]3q_NLGo\u001c:z\u0013\t\u0019\u0004G\u0001\u0011F]ZL'o\u001c8nK:$(+Z:feZ\fG/[8o%\u0016\u0004xn]5u_JL\u0018AE3om&\u0014xN\\7f]R\u001cVM\u001d<jG\u0016\u0004\"AN\u001c\u000e\u0003MI!\u0001O\n\u0003%\u0015sg/\u001b:p]6,g\u000e^*feZL7-Z\u0001\u0013CB\u0004H.[2bi&|gnU3sm&\u001cW\r\u0005\u00027w%\u0011Ah\u0005\u0002\u0013\u0003B\u0004H.[2bi&|gnU3sm&\u001cW-\u0001\u0005fm\u0016tGOQ;t!\ty$)D\u0001A\u0015\t\tu#\u0001\u0004fm\u0016tGo]\u0005\u0003\u0007\u0002\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q)ai\u0012%J\u0015B\u0011a\u0007\u0001\u0005\u0006[\u0015\u0001\rA\f\u0005\u0006i\u0015\u0001\r!\u000e\u0005\u0006s\u0015\u0001\rA\u000f\u0005\u0006{\u0015\u0001\rA\u0010\u0015\u0003\u000b1\u0003\"!\u0014-\u000e\u00039S!a\u0014)\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002R%\u00069a-Y2u_JL(BA*U\u0003\u0015\u0011W-\u00198t\u0015\t)f+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u00059\u0016aA8sO&\u0011\u0011L\u0014\u0002\n\u0003V$xn^5sK\u0012\f!c]3be\u000eD'+Z:feZ\fG/[8ogR\u0011A,\u001d\t\u0005;\n$7.D\u0001_\u0015\ty\u0006-\u0001\u0003vi&d'\"A1\u0002\t)\fg/Y\u0005\u0003Gz\u00131!T1q!\t)\u0017.D\u0001g\u0015\t1rM\u0003\u0002i/\u00051Am\\7bS:L!A\u001b4\u0003\u0017\u0015sg/\u001b:p]6,g\u000e\u001e\t\u0004;2t\u0017BA7_\u0005\u0011a\u0015n\u001d;\u0011\u0005\u0015|\u0017B\u00019g\u0005Y)eN^5s_:lWM\u001c;SKN,'O^1uS>t\u0007\"\u0002:\u0007\u0001\u0004\u0019\u0018a\u00024jYR,'o\u001d\t\u0003inl\u0011!\u001e\u0006\u0003m^\faAZ5mi\u0016\u0014(B\u0001=z\u0003\t1\u0018G\u0003\u0002{/\u0005\u0019\u0011\r]5\n\u0005q,(A\u0005*fg\u0016\u0014h/\u0019;j_:4\u0015\u000e\u001c;feND#A\u0002@\u0011\u0007}\fY!\u0004\u0002\u0002\u0002)\u0019q*a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\b[\u0016$(/[2t\u0015\r\tIaG\u0001\tG>$\u0017\r[1mK&!\u0011QBA\u0001\u0005\u0015!\u0016.\\3e\u0003M1\u0017N\u001c3SKN,'O^1uS>t')_%e)\rq\u00171\u0003\u0005\b\u0003+9\u0001\u0019AA\f\u0003a)gN^5s_:lWM\u001c;SKN,'O^1uS>t\u0017\n\u001a\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000fC5\u0011\u0011q\u0004\u0006\u0004\u0003Ci\u0012A\u0002\u001fs_>$h(C\u0002\u0002&\u0005\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013C!\u0012qA`\u0001\u001fO\u0016$(+Z:feZ\fG/[8og\nKXI\u001c<je>tW.\u001a8u\u0013\u0012$2a[A\u001a\u0011\u001d\t)\u0004\u0003a\u0001\u0003/\tQ\"\u001a8wSJ|g.\\3oi&#\u0007F\u0001\u0005\u007f\u0003E\u0019'/Z1uKJ+7/\u001a:wCRLwN\u001c\u000b\u0004]\u0006u\u0002BBA \u0013\u0001\u0007a.\u0001\ff]ZL'o\u001c8nK:$(+Z:feZ\fG/[8oQ\tIa0A\tva\u0012\fG/\u001a*fg\u0016\u0014h/\u0019;j_:$2A\\A$\u0011\u0019\tyD\u0003a\u0001]\"\u0012!B`\u0001\u0012I\u0016dW\r^3SKN,'O^1uS>tG\u0003BA(\u0003+\u00022\u0001IA)\u0013\r\t\u0019&\t\u0002\u0005+:LG\u000fC\u0004\u0002\u0016-\u0001\r!a\u0006)\u0005-q\u0018!E3ySN$8OU3tKJ4\u0018\r^5p]R1\u0011QLA2\u0003K\u00022\u0001IA0\u0013\r\t\t'\t\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u0004\u0004a\u0001\u0003/Aq!a\u001a\r\u0001\u0004\t9\"A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u0015\u0003\u0019y\f\u0001D\\3be\u0016\u001cHoQ8nS:<'+Z:feZ\fG/[8o)\u0019\ty'!\u001e\u0002xA\u0019Q,!\u001d\n\u0007\u0005MdL\u0001\u0003ECR,\u0007bBA\u001b\u001b\u0001\u0007\u0011q\u0003\u0005\b\u0003Oj\u0001\u0019AA\fQ\tia0\u0001\u0005wC2LG-\u0019;f)\u0011\ty%a \t\r\u0005}b\u00021\u0001o\u000351\u0018\r\\5eCR,G)\u0019;fgR!\u0011qJAC\u0011\u0019\tyd\u0004a\u0001]\u0006aa/\u00197jI\u0006$XMT8uKR!\u0011qJAF\u0011\u0019\ty\u0004\u0005a\u0001]\u0006!b/\u00197jI\u0006$X-\u00119qY&\u001c\u0017\r^5p]N$B!a\u0014\u0002\u0012\"1\u0011qH\tA\u00029D3\u0001AAK!\u0011\t9*!(\u000e\u0005\u0005e%bAAN)\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005}\u0015\u0011\u0014\u0002\b'\u0016\u0014h/[2f\u0001")
public class EnvironmentReservationService
implements Logging {
    private final EnvironmentReservationRepository environmentReservationRepository;
    private final ApplicationService applicationService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentReservationService environmentReservationService = this;
        synchronized (environmentReservationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public java.util.Map<Environment, List<EnvironmentReservation>> searchReservations(ReservationFilters filters) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.environmentReservationRepository.search(filters, package$.MODULE$.defaultPage()).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter(x$1).asJava())).asJava();
    }

    @Timed
    public EnvironmentReservation findReservationById(String environmentReservationId) {
        return this.environmentReservationRepository.findById(environmentReservationId);
    }

    @Timed
    public List<EnvironmentReservation> getReservationsByEnvironmentId(String environmentId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentReservationRepository.getAllForEnvironmentId(environmentId)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation createReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating a new environment reservation");
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.create(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationCreatedEvent(reservation));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public EnvironmentReservation updateReservation(EnvironmentReservation environmentReservation) {
        void var2_2;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Updating environment reservation [").append((Object)environmentReservation).append("]").toString());
        Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environmentReservation);
        EnvironmentReservation reservation = this.environmentReservationRepository.update(environmentReservation);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationUpdatedEvent(reservation));
        return var2_2;
    }

    @Timed
    public void deleteReservation(String environmentReservationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Deleting environment reservation [").append(environmentReservationId).append("]").toString());
        EnvironmentReservation reservation = this.environmentReservationRepository.findById(environmentReservationId);
        this.environmentReservationRepository.delete(environmentReservationId);
        this.eventBus.publish((XLReleaseEvent)new EnvironmentReservationDeletedEvent(reservation));
    }

    @Timed
    public boolean existsReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Checking reservation for environmentId [").append(environmentId).append("] and applicationId [").append(applicationId).append("]").toString());
        return this.environmentReservationRepository.existsByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date());
    }

    @Timed
    public Date nearestComingReservation(String environmentId, String applicationId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Checking nearest coming reservation for environmentId [").append(environmentId).append("] and applicationId [").append(applicationId).append("]").toString());
        return (Date)this.environmentReservationRepository.findNearestComingByEnvironmentIdAndApplicationIdAndDate(environmentId, applicationId, new Date()).orNull(Predef$.MODULE$.$conforms());
    }

    private void validate(EnvironmentReservation environmentReservation) {
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environmentReservation.getEnvironment()).exists((Function1 & Serializable & scala.Serializable)env -> BoxesRunTime.boxToBoolean((boolean)EnvironmentReservationService.$anonfun$validate$1(env))), (String)"Environment ID is required", (Object[])new Object[0]);
        this.validateDates(environmentReservation);
        this.validateNote(environmentReservation);
        this.validateApplications(environmentReservation);
    }

    private void validateDates(EnvironmentReservation environmentReservation) {
        Date startDate = environmentReservation.getStartDate();
        Date endDate = environmentReservation.getEndDate();
        Checks.checkArgument((startDate != null ? 1 : 0) != 0, (String)"Start date is required", (Object[])new Object[0]);
        Checks.checkArgument((endDate != null ? 1 : 0) != 0, (String)"End date is required", (Object[])new Object[0]);
        Checks.checkArgument((boolean)startDate.before(endDate), (String)"Start date must be before the end date", (Object[])new Object[0]);
    }

    private void validateNote(EnvironmentReservation environmentReservation) {
        block0: {
            if (environmentReservation.getNote() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environmentReservation.getNote()), (String)"Note cannot be blank", (Object[])new Object[0]);
        }
    }

    private void validateApplications(EnvironmentReservation environmentReservation) {
        if (CollectionUtils.isNotEmpty(environmentReservation.getApplications())) {
            Set allowedAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.applicationService.getApplicationsDeployableOnEnvironment(environmentReservation.getEnvironment().getId())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set givenAppIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(environmentReservation.getApplications()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set diff = (Set)givenAppIds.diff((GenSet)allowedAppIds);
            if (diff.nonEmpty()) {
                Tuple2 tuple2 = diff.splitAt(10);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Set first10 = (Set)tuple2._1();
                Set rest = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)first10, (Object)rest);
                Tuple2 tuple23 = tuple22;
                Set first102 = (Set)tuple23._1();
                Set rest2 = (Set)tuple23._2();
                throw new Checks.IncorrectArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n             |The following applications are not deployable on environment [").append(environmentReservation.getEnvironment().getId()).append("]:\n             |[").append(first102.mkString(", ")).append("] ").append((Object)(rest2.nonEmpty() ? ", and more" : BoxedUnit.UNIT)).append("\n             |").toString())).stripMargin(), new Object[0]);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(Environment env) {
        return StringUtils.hasText((String)env.getId());
    }

    @Autowired
    public EnvironmentReservationService(EnvironmentReservationRepository environmentReservationRepository, EnvironmentService environmentService, ApplicationService applicationService, XLReleaseEventBus eventBus) {
        this.environmentReservationRepository = environmentReservationRepository;
        this.applicationService = applicationService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

