/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VariableContainer;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.TileHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.service.TileScriptExecutor;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\n\u0014\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u00115\u0003!\u0011!Q\u0001\n9CQ!\u0015\u0001\u0005\u0002ICqA\u001b\u0001C\u0002\u0013\u00051\u000e\u0003\u0004u\u0001\u0001\u0006I\u0001\u001c\u0005\bk\u0002\u0011\r\u0011\"\u0001l\u0011\u00191\b\u0001)A\u0005Y\")q\u000f\u0001C\u0001q\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\tI\n\u0001C\u0001\u00037\u00131\u0002V5mKN+'O^5dK*\u0011A#F\u0001\bg\u0016\u0014h/[2f\u0015\t1r#A\u0005eCND'm\\1sI*\u0011\u0001$G\u0001\ba2,x-\u001b8t\u0015\tQ2$A\u0005yYJ,G.Z1tK*\u0011A$H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AH\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005)1\u000f\u001c45U*\tA&\u0001\u0005he&T(\u0010\\3e\u0013\tq\u0013FA\u0004M_\u001e<\u0017N\\4\u0002\u001dI,G.Z1tKN+'O^5dKB\u0011\u0011gM\u0007\u0002e)\u0011A#G\u0005\u0003iI\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW-A\u0007g_2$WM]*feZL7-\u001a\t\u0003c]J!\u0001\u000f\u001a\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0003=1\u0018M]5bE2,7+\u001a:wS\u000e,\u0007CA\u0019<\u0013\ta$GA\bWCJL\u0017M\u00197f'\u0016\u0014h/[2f\u0003M!\u0017m\u001d5c_\u0006\u0014HMU3q_NLGo\u001c:z!\ty$)D\u0001A\u0015\t\tU#\u0001\u0006sKB|7/\u001b;pefL!a\u0011!\u0003;\u0011+G.Z4bi&tw\rR1tQ\n|\u0017M\u001d3SKB|7/\u001b;pef\f!\u0003^5mKN\u001b'/\u001b9u\u000bb,7-\u001e;peB\u0011aiR\u0007\u0002'%\u0011\u0001j\u0005\u0002\u0013)&dWmU2sSB$X\t_3dkR|'/A\u0006uK\u0006l7+\u001a:wS\u000e,\u0007CA\u0019L\u0013\ta%GA\u0006UK\u0006l7+\u001a:wS\u000e,\u0017!\u00064pY\u0012,'OV1sS\u0006\u0014G.Z*feZL7-\u001a\t\u0003c=K!\u0001\u0015\u001a\u0003+\u0019{G\u000eZ3s-\u0006\u0014\u0018.\u00192mKN+'O^5dK\u00061A(\u001b8jiz\"\u0002b\u0015+V-^C\u0016L\u0017\t\u0003\r\u0002AQa\f\u0005A\u0002ABQ!\u000e\u0005A\u0002YBQ!\u000f\u0005A\u0002iBQ!\u0010\u0005A\u0002yBQ\u0001\u0012\u0005A\u0002\u0015CQ!\u0013\u0005A\u0002)CQ!\u0014\u0005A\u00029C#\u0001\u0003/\u0011\u0005uCW\"\u00010\u000b\u0005}\u0003\u0017AC1o]>$\u0018\r^5p]*\u0011\u0011MY\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0019G-A\u0003cK\u0006t7O\u0003\u0002fM\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001h\u0003\ry'oZ\u0005\u0003Sz\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u001d\r\f7\r[3CkN$XM]&fsV\tA\u000e\u0005\u0002ne6\taN\u0003\u0002pa\u0006!A.\u00198h\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d8\u0003\rM#(/\u001b8h\u0003=\u0019\u0017m\u00195f\u0005V\u001cH/\u001a:LKf\u0004\u0013A\u0003:fMJ,7\u000f[&fs\u0006Y!/\u001a4sKND7*Z=!\u0003U)\u00070Z2vi\u0016$\u0016\u000e\\3ECR\f7k\u0019:jaR$B!\u001f?\u0002\u0012A\u0011!E_\u0005\u0003w\u000e\u00121!\u00118z\u0011\u0015iX\u00021\u0001\u007f\u0003\u0019!\u0018\u000e\\3JIB\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u0007\u0019SBAA\u0003\u0015\r\t9aH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-1%\u0001\u0004Qe\u0016$WMZ\u0005\u0004g\u0006=!bAA\u0006G!9\u00111C\u0007A\u0002\u0005U\u0011aE1eI&$\u0018n\u001c8bYZ\u000b'/[1cY\u0016\u001c\b#B@\u0002\u0018yL\u0018\u0002BA\r\u0003\u001f\u00111!T1qQ\ri\u0011Q\u0004\t\u0005\u0003?\tY#\u0004\u0002\u0002\")\u0019q,a\t\u000b\t\u0005\u0015\u0012qE\u0001\b[\u0016$(/[2t\u0015\r\tI#H\u0001\tG>$\u0017\r[1mK&!\u0011QFA\u0011\u0005\u0015!\u0016.\\3e\u0003%9W\r\u001e)be\u0016tG\u000f\u0006\u0003\u00024\u0005\u0015\u0003#\u0002\u0012\u00026\u0005e\u0012bAA\u001cG\t1q\n\u001d;j_:\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fI\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002D\u0005u\"!\u0005,be&\f'\r\\3D_:$\u0018-\u001b8fe\"1aC\u0004a\u0001\u0003\u000f\u0002B!!\u0013\u0002N5\u0011\u00111\n\u0006\u0004\u0003\u007f)\u0012\u0002BA(\u0003\u0017\u0012\u0011\u0002R1tQ\n|\u0017M\u001d3\u0002\u0019\u001d,G\u000fV5mKRK\b/Z:\u0015\t\u0005U\u0013q\u0010\t\u0007\u0003/\n\t'a\u001a\u000f\t\u0005e\u0013Q\f\b\u0005\u0003\u0007\tY&C\u0001%\u0013\r\tyfI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019'!\u001a\u0003\u0007M+\u0017OC\u0002\u0002`\r\u0002B!!\u001b\u0002|5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0004sK\u001adWm\u0019;\u000b\t\u0005E\u00141O\u0001\u0004CBL'\u0002BA;\u0003o\na\u0001\u001d7vO&t'bAA=7\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002~\u0005-$A\u0003#fg\u000e\u0014\u0018\u000e\u001d;pe\"9\u0011\u0011Q\bA\u0002\u0005\r\u0015!B:d_B,\u0007\u0003BA%\u0003\u000bKA!a\"\u0002L\tIA+\u001b7f'\u000e|\u0007/\u001a\u0015\u0004\u001f\u0005u\u0011\u0001\u00044j]\u0012$\u0016\u000e\\3Cs&#G\u0003BAH\u0003+\u0003B!!\u0013\u0002\u0012&!\u00111SA&\u0005\u0011!\u0016\u000e\\3\t\u000bu\u0004\u0002\u0019\u0001@)\u0007A\ti\"\u0001\u0006va\u0012\fG/\u001a+jY\u0016$B!a$\u0002\u001e\"9\u0011qT\tA\u0002\u0005=\u0015\u0001\u0002;jY\u0016D3!EA\u000fQ\r\u0001\u0011Q\u0015\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u00163\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u00020\u0006%&aB*feZL7-\u001a")
public class TileService
implements Logging {
    private final ReleaseService releaseService;
    private final FolderService folderService;
    private final VariableService variableService;
    private final DelegatingDashboardRepository dashboardRepository;
    private final TileScriptExecutor tileScriptExecutor;
    private final TeamService teamService;
    private final FolderVariableService folderVariableService;
    private final String cacheBusterKey;
    private final String refreshKey;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TileService tileService = this;
        synchronized (tileService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String cacheBusterKey() {
        return this.cacheBusterKey;
    }

    public String refreshKey() {
        return this.refreshKey;
    }

    @Timed
    public Object executeTileDataScript(String tileId, Map<String, Object> additionalVariables) {
        Map variablesWithoutCacheBuster;
        Tile resolvedTile;
        Option<VariableContainer> parent;
        block0: {
            String dashboardId = Ids.getParentId((String)tileId);
            Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
            Tile tile = dashboard.getTile(tileId);
            parent = this.getParent(dashboard);
            Buffer globalVariables = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.variableService.findGlobalVariablesOrEmpty().getVariables()).asScala();
            Buffer folderVariables = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.folderVariableService.getAllFromAncestry(Ids.findFolderId((String)dashboardId)).getVariables()).asScala();
            resolvedTile = TileHelper$.MODULE$.resolveVariables(tile, parent, (Seq<Variable>)globalVariables.$plus$plus((GenTraversableOnce)folderVariables));
            variablesWithoutCacheBuster = (Map)additionalVariables.$minus((Object)this.cacheBusterKey()).$minus((Object)this.refreshKey());
            if (!additionalVariables.contains((Object)this.refreshKey())) break block0;
            this.tileScriptExecutor.evictFromCache(parent, resolvedTile, (Map<String, Object>)variablesWithoutCacheBuster);
        }
        return this.tileScriptExecutor.executeTileScript(parent, resolvedTile, (Map<String, Object>)variablesWithoutCacheBuster);
    }

    private Option<VariableContainer> getParent(Dashboard dashboard) {
        None$ none$;
        String string = (String)Option$.MODULE$.apply((Object)dashboard.getParentId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> PermissionChecker$.MODULE$.GLOBAL_SECURITY_ALIAS());
        if (Ids.isReleaseId((String)string)) {
            Release release = this.releaseService.findByIdIncludingArchived(string);
            this.teamService.decorateWithEffectiveTeams(release);
            none$ = new Some((Object)release);
        } else if (Ids.isFolderId((String)string)) {
            Folder folder = this.folderService.findById(string, Predef$.MODULE$.int2Integer(0));
            none$ = new Some((Object)folder);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Timed
    public Seq<Descriptor> getTileTypes(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Tile.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)TileService.$anonfun$getTileTypes$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public Tile findTileById(String tileId) {
        return this.dashboardRepository.findTileById(tileId);
    }

    @Timed
    public Tile updateTile(Tile tile) {
        Tile original = this.findTileById(tile.getId());
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)tile);
        return this.dashboardRepository.updateTile(tile);
    }

    public static final /* synthetic */ boolean $anonfun$getTileTypes$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Tile)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    @Autowired
    public TileService(ReleaseService releaseService, FolderService folderService, VariableService variableService, DelegatingDashboardRepository dashboardRepository, TileScriptExecutor tileScriptExecutor, TeamService teamService, FolderVariableService folderVariableService) {
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.variableService = variableService;
        this.dashboardRepository = dashboardRepository;
        this.tileScriptExecutor = tileScriptExecutor;
        this.teamService = teamService;
        this.folderVariableService = folderVariableService;
        Logging.$init$((Logging)this);
        this.cacheBusterKey = "cb";
        this.refreshKey = "refresh";
    }
}

