/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t%b\u0001\u0002\u000e\u001c\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011q\u0003!Q1A\u0005\u0004uC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\u0006s\u0002!\tA\u001f\u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0001\u0003\u0013Bq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\t\u0019\f\u0001C\t\u0003kCq!a/\u0001\t\u0013\ti\fC\u0004\u0002B\u0002!I!a1\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f\u0011\u0001\u0003R1tQ\n|\u0017M\u001d3TKJ4\u0018nY3\u000b\u0005qi\u0012aB:feZL7-\u001a\u0006\u0003=}\t\u0011\u0002Z1tQ\n|\u0017M\u001d3\u000b\u0005\u0001\n\u0013a\u00029mk\u001eLgn\u001d\u0006\u0003E\r\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0011*\u0013!\u0003=fE&\fG.\u00192t\u0015\u00051\u0013aA2p[\u000e\u00011C\u0001\u0001*!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fM\u0006\u0019B-Y:iE>\f'\u000f\u001a*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0007N\u0007\u0002e)\u00111'H\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001b3\u0005u!U\r\\3hCRLgn\u001a#bg\"\u0014w.\u0019:e%\u0016\u0004xn]5u_JL\u0018!\u00053bg\"\u0014w.\u0019:e'\u0016\u001cWO]5usB\u0011\u0001(O\u0007\u00027%\u0011!h\u0007\u0002\u0012\t\u0006\u001c\bNY8be\u0012\u001cVmY;sSRL\u0018A\u00073bg\"\u0014w.\u0019:e'\u0016\u001cWO]5us\u0012+7m\u001c:bi>\u0014\bC\u0001\u001d>\u0013\tq4D\u0001\u000eECND'm\\1sIN+7-\u001e:jif$UmY8sCR|'/\u0001\u0007dC\u000eDW-T1oC\u001e,'\u000f\u0005\u0002B\u00116\t!I\u0003\u0002D\t\u0006)1-Y2iK*\u0011QIR\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq)A\u0002pe\u001eL!!\u0013\"\u0003\u0019\r\u000b7\r[3NC:\fw-\u001a:\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000b\u0001b]3dkJLG/\u001f\u0006\u0003!\u000e\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003%6\u00131BU8mKN+'O^5dK\u0006i1o\u0019:jaR\u001cVM\u001d<jG\u0016\u0004\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\r)LH\u000f[8o\u0015\tI\u0016%\u0001\u0004tGJL\u0007\u000f^\u0005\u00037Z\u00131CS=uQ>t7k\u0019:jaR\u001cVM\u001d<jG\u0016\f1bY5JIN+'O^5dKV\ta\f\u0005\u0002`C6\t\u0001M\u0003\u0002\u001dC%\u0011!\r\u0019\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\tM\u001eD\u0017N[6m[B\u0011\u0001\b\u0001\u0005\u0006_%\u0001\r\u0001\r\u0005\u0006m%\u0001\ra\u000e\u0005\u0006w%\u0001\r\u0001\u0010\u0005\u0006\u007f%\u0001\r\u0001\u0011\u0005\u0006\u0015&\u0001\ra\u0013\u0005\u0006'&\u0001\r\u0001\u0016\u0005\u00069&\u0001\u001dA\u0018\u0015\u0003\u0013=\u0004\"\u0001]<\u000e\u0003ET!A]:\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002uk\u00069a-Y2u_JL(B\u0001<E\u0003\u0015\u0011W-\u00198t\u0013\tA\u0018OA\u0005BkR|w/\u001b:fI\u000611/Z1sG\"$Ra_A\u000e\u0003_\u0001R\u0001`A\u0005\u0003\u001fq1!`A\u0003\u001d\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013bAA\u0004W\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0006\u0003\u001b\u00111aU3r\u0015\r\t9a\u000b\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u000f\u0002\r\u0011|W.Y5o\u0013\u0011\tI\"a\u0005\u0003\u0013\u0011\u000b7\u000f\u001b2pCJ$\u0007bBA\u000f\u0015\u0001\u0007\u0011qD\u0001\ta\u0006\u0014XM\u001c;JIB!\u0011\u0011EA\u0015\u001d\u0011\t\u0019#!\n\u0011\u0005y\\\u0013bAA\u0014W\u00051\u0001K]3eK\u001aLA!a\u000b\u0002.\t11\u000b\u001e:j]\u001eT1!a\n,\u0011%\t\tD\u0003I\u0001\u0002\u0004\ty\"A\u0003uSRdW\rK\u0002\u000b\u0003k\u0001B!a\u000e\u0002D5\u0011\u0011\u0011\b\u0006\u0004e\u0006m\"\u0002BA\u001f\u0003\u007f\tq!\\3ue&\u001c7OC\u0002\u0002B\u0015\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003\u000b\nIDA\u0003US6,G-\u0001\ttK\u0006\u00148\r\u001b\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\n\u0016\u0005\u0003?\tie\u000b\u0002\u0002PA!\u0011\u0011KA-\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013!C;oG\",7m[3e\u0015\t\u00118&\u0003\u0003\u0002\\\u0005M#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tb-\u001b8e\t\u0006\u001c\bNY8be\u0012\u0014\u00150\u00133\u0015\t\u0005=\u0011\u0011\r\u0005\b\u0003Gb\u0001\u0019AA\u0010\u0003-!\u0017m\u001d5c_\u0006\u0014H-\u00133)\u00071\t)$A\bde\u0016\fG/\u001a#bg\"\u0014w.\u0019:e)\u0011\ty!a\u001b\t\ryi\u0001\u0019AA\bQ\ri\u0011QG\u0001\u0010kB$\u0017\r^3ECND'm\\1sIR!\u0011qBA:\u0011\u0019qb\u00021\u0001\u0002\u0010!\u001aa\"!\u000e\u0002\u001f\u0011,G.\u001a;f\t\u0006\u001c\bNY8be\u0012$B!a\u001f\u0002\u0002B\u0019!&! \n\u0007\u0005}4F\u0001\u0003V]&$\bbBA2\u001f\u0001\u0007\u0011q\u0004\u0015\u0004\u001f\u0005U\u0012!F4fi\u0012\u000b7\u000f\u001b2pCJ$G+Z7qY\u0006$Xm\u001d\u000b\u0005\u0003\u0013\u000by\nE\u0003}\u0003\u0013\tY\t\u0005\u0003\u0002\u000e\u0006mUBAAH\u0015\u0011\t\t*a%\u0002\u000fI,g\r\\3di*!\u0011QSAL\u0003\r\t\u0007/\u001b\u0006\u0004\u00033{\u0015A\u00029mk\u001eLg.\u0003\u0003\u0002\u001e\u0006=%A\u0003#fg\u000e\u0014\u0018\u000e\u001d;pe\"9\u0011\u0011\u0015\tA\u0002\u0005\r\u0016!B:d_B,\u0007\u0003BA\t\u0003KKA!a*\u0002\u0014\tIA+\u001b7f'\u000e|\u0007/\u001a\u0015\u0004!\u0005U\u0012aD3wS\u000e$H+\u001b7fg\u000e\u000b7\r[3\u0015\t\u0005m\u0014q\u0016\u0005\u0007=E\u0001\r!a\u0004)\u0007E\t)$A\u000feK\u000e|'/\u0019;f/&$\b.\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001b;z)\rY\u0018q\u0017\u0005\u0007\u0003s\u0013\u0002\u0019A>\u0002\u0015\u0011\f7\u000f\u001b2pCJ$7/\u0001\u0005wC2LG-\u0019;f)\u0011\tY(a0\t\ry\u0019\u0002\u0019AA\b\u0003E\u0019X\r^(x]\u0016\u0014\u0018JZ'jgNLgn\u001a\u000b\u0005\u0003w\n)\r\u0003\u0004\u001f)\u0001\u0007\u0011qB\u0001\u0012GV\u0014(/\u001a8u!JLgnY5qC2\u001cXCAAf!\u0019\ti-a5\u0002X6\u0011\u0011q\u001a\u0006\u0004\u0003#\\\u0013AC2pY2,7\r^5p]&!\u0011Q[Ah\u0005!IE/\u001a:bE2,\u0007\u0003BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\u0005Y\u0006twM\u0003\u0002\u0002b\u0006!!.\u0019<b\u0013\u0011\tY#a7\u0002\u0019\r,(O]3oiJ{G.Z:\u0016\u0005\u0005%\bCBAv\u0003c\f)0\u0004\u0002\u0002n*!\u0011q^Ah\u0003\u001diW\u000f^1cY\u0016LA!a=\u0002n\n1!)\u001e4gKJ\u00042\u0001TA|\u0013\r\tI0\u0014\u0002\u0005%>dW-\u0001\nqe>4\u0018n]5p]\u0012\u000b7\u000f\u001b2pCJ$G\u0003BA\u0000\u0005\u000b\u00012A\u000bB\u0001\u0013\r\u0011\u0019a\u000b\u0002\u0004\u0003:L\bB\u0002\u0010\u0018\u0001\u0004\ty!\u0001\ffq\u0016\u001cW\u000f^3Qe>4\u0018n]5p]N\u001b'/\u001b9u)\u0011\tyAa\u0003\t\ryA\u0002\u0019AA\b\u0003M\u0019'/Z1uKN\u001b'/\u001b9u\u0007>tG/\u001a=u)\u0011\u0011\tB!\u0007\u0011\t\tM!QC\u0007\u00021&\u0019!q\u0003-\u0003!ac'oU2sSB$8i\u001c8uKb$\bB\u0002\u0010\u001a\u0001\u0004\ty\u0001K\u0002\u0001\u0005;\u0001BAa\b\u0003&5\u0011!\u0011\u0005\u0006\u0004\u0005G!\u0015AC:uKJ,w\u000e^=qK&!!q\u0005B\u0011\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final CiIdService ciIdService;

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.cacheManager.getCacheNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            String script = ScriptHelper.getScript((ConfigurationItem)dashboard);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    /*
     * WARNING - void declaration
     */
    private XlrScriptContext createScriptContext(Dashboard dashboard) {
        void var2_2;
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.addApi();
        scriptContext.setAttribute("dashboard", (Object)dashboard, 100);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(cache.asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.ciIdService = ciIdService;
    }
}

