/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.repository.SqlDashboardRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u00033bg\"\u0014w.\u0019:e\u0015\t9\u0001\"A\u0004qYV<\u0017N\\:\u000b\u0005%Q\u0011!\u0003=me\u0016dW-Y:f\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aD\u0001b\u0006\u0001\u0003\u0006\u0004%\t\u0001G\u0001\u0012a\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014X#A\r\u0011\u0005iiR\"A\u000e\u000b\u0005qA\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\u0005yY\"!\u0005)fe6L7o]5p]\u000eCWmY6fe\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011$\u0001\nqKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011A\u0012\u0002\u0017I|G.Z*feZL7-Z\u000b\u0002IA\u0011Q%K\u0007\u0002M)\u0011Ad\n\u0006\u0003Q)\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003U\u0019\u00121BU8mKN+'O^5dK\"AA\u0006\u0001B\u0001B\u0003%A%\u0001\u0007s_2,7+\u001a:wS\u000e,\u0007\u0005\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0003)\u0019XmY;sK\u0012\u001c\u0015n]\u000b\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007C\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001b3\u0005)\u0019VmY;sK\u0012\u001c\u0015n\u001d\u0005\to\u0001\u0011\t\u0011)A\u0005a\u0005Y1/Z2ve\u0016$7)[:!\u0011!I\u0004A!b\u0001\n\u0003Q\u0014A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ,\u0012a\u000f\t\u0003KqJ!!\u0010\u0014\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w\u0005\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA!A\u0011\t\u0001BC\u0002\u0013\u0005!)\u0001\tqKJl\u0017n]:j_:,E-\u001b;peV\t1\t\u0005\u0002&\t&\u0011QI\n\u0002\u0011!\u0016\u0014X.[:tS>tW\tZ5u_JD\u0001b\u0012\u0001\u0003\u0002\u0003\u0006IaQ\u0001\u0012a\u0016\u0014X.[:tS>tW\tZ5u_J\u0004\u0003\u0002C%\u0001\u0005\u000b\u0007I\u0011\u0001&\u0002'\u0011\f7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\u0016\u0003-\u0003\"\u0001\u0014(\u000e\u00035S!a\r\u0003\n\u0005=k%AF*rY\u0012\u000b7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\t\u0011E\u0003!\u0011!Q\u0001\n-\u000bA\u0003Z1tQ\n|\u0017M\u001d3SKB|7/\u001b;pef\u0004\u0003\"B*\u0001\t\u0003!\u0016A\u0002\u001fj]&$h\bF\u0004V/bK&l\u0017/\u0011\u0005Y\u0003Q\"\u0001\u0002\t\u000b]\u0011\u0006\u0019A\r\t\u000b\t\u0012\u0006\u0019\u0001\u0013\t\u000b9\u0012\u0006\u0019\u0001\u0019\t\u000be\u0012\u0006\u0019A\u001e\t\u000b\u0005\u0013\u0006\u0019A\"\t\u000b%\u0013\u0006\u0019A&)\u0005Is\u0006CA0k\u001b\u0005\u0001'BA1c\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003G\u0012\fqAZ1di>\u0014\u0018P\u0003\u0002fM\u0006)!-Z1og*\u0011q\r[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011.A\u0002pe\u001eL!a\u001b1\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B7\u0001\t\u0003q\u0017aC2iK\u000e\\7I]3bi\u0016$\"a\u001c:\u0011\u0005E\u0001\u0018BA9\u0013\u0005\u0011)f.\u001b;\t\u000bMd\u0007\u0019\u0001;\u0002\u0011A\f'/\u001a8u\u0013\u0012\u0004\"!\u001e?\u000f\u0005YT\bCA<\u0013\u001b\u0005A(BA=\u000f\u0003\u0019a$o\\8u}%\u00111PE\u0001\u0007!J,G-\u001a4\n\u0005ut(AB*ue&twM\u0003\u0002|%!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0011!C2iK\u000e\\W\tZ5u)\ry\u0017Q\u0001\u0005\u0007\u0003\u000fy\b\u0019\u0001;\u0002\u0017\u0011\f7\u000f\u001b2pCJ$\u0017\n\u001a\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003%\u0019\u0007.Z2l-&,w\u000fF\u0002p\u0003\u001fAq!a\u0002\u0002\n\u0001\u0007A\u000fC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002\u001d\u001d,G\u000fU3s[&\u001c8/[8ogR!\u0011qCA !!\tI\"a\t\u0002(\u00055RBAA\u000e\u0015\u0011\ti\"a\b\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011\u0005\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002&\u0005m!aA'baB\u0019Q%!\u000b\n\u0007\u0005-bE\u0001\u0003S_2,\u0007CBA\r\u0003_\t\u0019$\u0003\u0003\u00022\u0005m!aA*fiB!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\u0019\n!\u0002]3s[&\u001c8/[8o\u0013\u0011\ti$a\u000e\u0003\u0015A+'/\\5tg&|g\u000eC\u0004\u0006\u0003#\u0001\r!!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012\u0005\u0003\u0019!w.\\1j]&!\u00111JA#\u0005%!\u0015m\u001d5c_\u0006\u0014H\rC\u0004\u0002P\u0001!\t!!\u0015\u0002\u001fM\fg/\u001a)fe6L7o]5p]N$2a\\A*\u0011\u001d)\u0011Q\na\u0001\u0003\u0003Bq!a\u0016\u0001\t\u0003\tI&\u0001\tdY\u0016\f'\u000fU3s[&\u001c8/[8ogR\u0019q.a\u0017\t\u000f\u0005\u001d\u0011Q\u000ba\u0001i\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014\u0001\u0003<bY&$\u0017\r^3\u0015\u0007=\f\u0019\u0007C\u0004\u0006\u0003;\u0002\r!!\u0011\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j\u0005\tb/\u00197jI\u0006$XMU8mK:\u000bW.Z:\u0015\u000b=\fY'!\u001e\t\u0011\u00055\u0014Q\ra\u0001\u0003_\n\u0011B]8mK:\u000bW.Z:\u0011\u000b\u0005e\u0011\u0011\u000f;\n\t\u0005M\u00141\u0004\u0002\u0007\u0005V4g-\u001a:\t\u0011\u0005]\u0014Q\ra\u0001\u0003s\n\u0001\"\u00197m%>dWm\u001d\t\u0007\u0003w\n))a\n\u000f\t\u0005u\u0014\u0011\u0011\b\u0004o\u0006}\u0014\"A\n\n\u0007\u0005\r%#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0015\u0011\u0012\u0002\u0004'\u0016\f(bAAB%!9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015!E4fi\u00063\u0018-\u001b7bE2,'k\u001c7fgR!\u0011\u0011PAI\u0011\u001d)\u00111\u0012a\u0001\u0003\u0003Bq!!&\u0001\t\u0013\t9*A\u0007tKR\u0004VM]7jgNLwN\u001c\u000b\n_\u0006e\u00151TAO\u0003?C\u0001\"!\u001c\u0002\u0014\u0002\u0007\u0011q\u000e\u0005\t\u0003s\t\u0019\n1\u0001\u00024!A\u0011qOAJ\u0001\u0004\tI\b\u0003\u0005\u0002\"\u0006M\u0005\u0019AAR\u0003-\u0001XM]7jgNLwN\\:\u0011\u0011\u0005\u0015\u0016qVA\u0014\u0003ck!!a*\u000b\t\u0005%\u00161V\u0001\u0005kRLGN\u0003\u0002\u0002.\u0006!!.\u0019<b\u0013\u0011\t)#a*\u0011\r\u0005\u0015\u00161WA\u001a\u0013\u0011\t\t$a*\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\u0006A2\r[3dW\u0012\u000b7\u000f\u001b2pCJ$\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\u000b=\fY,!0\t\u0011\u0005e\u0012Q\u0017a\u0001\u0003gAq!a\u0002\u00026\u0002\u0007A\u000fC\u0004\u0002B\u0002!I!a1\u0002/\u001d,G/\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001b;z+&$G\u0003BAc\u0003\u0017\u0004B!EAdi&\u0019\u0011\u0011\u001a\n\u0003\r=\u0003H/[8o\u0011\u001d)\u0011q\u0018a\u0001\u0003\u0003B3\u0001AAh!\u0011\t\t.a6\u000e\u0005\u0005M'bAAkM\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005e\u00171\u001b\u0002\b'\u0016\u0014h/[2f\u0001")
public class DashboardSecurity {
    private final PermissionChecker permissionChecker;
    private final RoleService roleService;
    private final SecuredCis securedCis;
    private final PermissionEnforcer permissionEnforcer;
    private final PermissionEditor permissionEditor;
    private final SqlDashboardRepository dashboardRepository;

    public PermissionChecker permissionChecker() {
        return this.permissionChecker;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public SecuredCis securedCis() {
        return this.securedCis;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public PermissionEditor permissionEditor() {
        return this.permissionEditor;
    }

    public SqlDashboardRepository dashboardRepository() {
        return this.dashboardRepository;
    }

    public void checkCreate(String parentId) {
        String string = (String)Option$.MODULE$.apply((Object)parentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> "global");
        if (Ids.isReleaseId((String)string)) {
            this.permissionChecker().checkEdit(string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Ids.isFolderId((String)string)) {
            this.permissionChecker().check(XLReleasePermissions.EDIT_DASHBOARD, parentId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.permissionChecker().check(XLReleasePermissions.CREATE_DASHBOARD);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void checkEdit(String dashboardId) {
        if (Ids.isReleaseId((String)Ids.getParentId((String)dashboardId))) {
            this.permissionChecker().checkEdit(Ids.getParentId((String)dashboardId));
        } else {
            this.checkDashboardPermission(XLReleasePermissions.EDIT_DASHBOARD, dashboardId);
        }
    }

    public void checkView(String dashboardId) {
        if (Ids.isReleaseId((String)Ids.getParentId((String)dashboardId))) {
            this.permissionChecker().checkView(Ids.getParentId((String)dashboardId));
        } else {
            this.checkDashboardPermission(XLReleasePermissions.VIEW_DASHBOARD, dashboardId);
        }
    }

    public scala.collection.mutable.Map<Role, scala.collection.mutable.Set<Permission>> getPermissions(Dashboard dashboard) {
        scala.collection.mutable.Map map;
        Option<String> option = this.getEffectiveSecurityUid(dashboard);
        if (option instanceof Some) {
            Some some = (Some)option;
            String securityUid = (String)some.value();
            Buffer roles = ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().readRoleAssignments()).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().readRoleAssignments(securityUid)).asScala());
            scala.collection.mutable.Map permissionsByRole = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.permissionEditor().readPermissions(securityUid)).asScala();
            map = (scala.collection.mutable.Map)permissionsByRole.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Role role = (Role)tuple2._1();
                Set permissions = (Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2(roles.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DashboardSecurity.$anonfun$getPermissions$2(role, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> role), JavaConverters$.MODULE$.asScalaSetConverter(permissions).asScala());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else {
            map = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public void savePermissions(Dashboard dashboard) {
        block2: {
            if (!dashboard.isGlobalDashboard()) break block2;
            Option<String> option = this.dashboardRepository().getSecurityUid(dashboard.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                String securityUid = (String)some.value();
                Seq<Role> roles = this.getAvailableRoles(dashboard);
                Map permissions = this.permissionEditor().readPermissions(securityUid);
                this.setPermission((Buffer<String>)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(dashboard.getRoleViewers()).asScala()), XLReleasePermissions.VIEW_DASHBOARD, roles, permissions);
                this.setPermission((Buffer<String>)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(dashboard.getRoleEditors()).asScala()), XLReleasePermissions.EDIT_DASHBOARD, roles, permissions);
                this.permissionEditor().editPermissions(securityUid, permissions);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void clearPermissions(String dashboardId) {
        Option<String> option = this.dashboardRepository().getSecurityUid(dashboardId);
        if (option instanceof Some) {
            Some some = (Some)option;
            String securityUid = (String)some.value();
            this.permissionEditor().editPermissions(securityUid, new HashMap());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validate(Dashboard dashboard) {
        Seq<Role> allRoles = this.getAvailableRoles(dashboard);
        this.validateRoleNames((Buffer<String>)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(dashboard.getRoleViewers()).asScala()), allRoles);
        this.validateRoleNames((Buffer<String>)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(dashboard.getRoleEditors()).asScala()), allRoles);
    }

    private void validateRoleNames(Buffer<String> roleNames, Seq<Role> allRoles) {
        roleNames.foreach((Function1 & Serializable & scala.Serializable)roleName -> (Role)allRoles.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DashboardSecurity.$anonfun$validateRoleNames$2(roleName, x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The role '", "' does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{roleName})), new Object[0]);
        }));
    }

    private Seq<Role> getAvailableRoles(Dashboard dashboard) {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)Option$.MODULE$.apply((Object)dashboard.getParentId()).map((Function1 & Serializable & scala.Serializable)parentId -> this.roleService().getRoles(this.securedCis().getEffectiveSecuredCi(parentId).getSecurityUid())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.roleService().getRoles())).asScala();
    }

    private void setPermission(Buffer<String> roleNames, Permission permission, Seq<Role> allRoles, Map<Role, Set<Permission>> permissions) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(permissions).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set rolePermissions = (Set)tuple2._2();
            BoxedUnit boxedUnit = rolePermissions != null ? BoxesRunTime.boxToBoolean((boolean)rolePermissions.remove(permission)) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        ((IterableLike)roleNames.flatMap((Function1 & Serializable & scala.Serializable)roleName -> Option$.MODULE$.option2Iterable(allRoles.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DashboardSecurity.$anonfun$setPermission$3(roleName, x$3)))), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)role -> {
            Set rolePermissions = permissions.getOrDefault(role, new HashSet());
            rolePermissions.add(permission);
            return permissions.put((Role)role, rolePermissions);
        });
    }

    private void checkDashboardPermission(Permission permission, String dashboardId) {
        Option<String> securityUid;
        Dashboard dashboard = this.dashboardRepository().findDashboardById(dashboardId);
        String string = dashboard.getOwner();
        String string2 = Permissions.getAuthenticatedUserName();
        if ((string == null ? string2 != null : !string.equals(string2)) && (securityUid = this.getEffectiveSecurityUid(dashboard)).isDefined() && !this.permissionEnforcer().hasLoggedInUserPermission(permission, (String)securityUid.get())) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)dashboardId);
        }
    }

    private Option<String> getEffectiveSecurityUid(Dashboard dashboard) {
        return dashboard.isFolderDashboard() ? Option$.MODULE$.apply((Object)this.securedCis().getEffectiveSecuredCi(dashboard.getParentId()).getSecurityUid()) : (dashboard.isGlobalDashboard() ? this.dashboardRepository().getSecurityUid(dashboard.getId()) : None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$getPermissions$2(Role role$1, Role x$1) {
        String string = x$1.getId();
        String string2 = role$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateRoleNames$2(String roleName$1, Role x$2) {
        String string = x$2.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$setPermission$3(String roleName$2, Role x$3) {
        String string = x$3.getName();
        String string2 = roleName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public DashboardSecurity(PermissionChecker permissionChecker, RoleService roleService, SecuredCis securedCis, PermissionEnforcer permissionEnforcer, PermissionEditor permissionEditor, SqlDashboardRepository dashboardRepository) {
        this.permissionChecker = permissionChecker;
        this.roleService = roleService;
        this.securedCis = securedCis;
        this.permissionEnforcer = permissionEnforcer;
        this.permissionEditor = permissionEditor;
        this.dashboardRepository = dashboardRepository;
    }
}

