package com.xebialabs.xlrelease.plugins.dashboard.repository

import com.xebialabs.deployit.security.Role
import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.plugins.dashboard.actors.extension.DashboardActorExtensionActorMessages._
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}
import com.xebialabs.xlrelease.repository.Ids.releaseIdFrom
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class ReleaseDashboardActorRepositoryAdapter @Autowired()(releaseActorService: ReleaseActorService,
                                                          wrappedRepository: ReleaseDashboardRepository)
  extends DashboardRepository {


  override def exists(dashboardId: String): Boolean = wrappedRepository.exists(dashboardId)

  override def search(parentId: String, title: String, principals: Iterable[String], roles: Iterable[Role], enforcePermissions: Boolean = true): Seq[Dashboard] =
    wrappedRepository.search(parentId, title, principals, roles, enforcePermissions)

  override def findDashboardById(dashboardId: String): Dashboard = wrappedRepository.findDashboardById(dashboardId)

  override def createDashboard(dashboard: Dashboard): Dashboard =
    releaseActorService.executeCommand(releaseIdFrom(dashboard.getId), CreateDashboard(dashboard))

  override def updateDashboard(dashboard: Dashboard): Dashboard =
    releaseActorService.executeCommand(releaseIdFrom(dashboard.getId), UpdateDashboard(dashboard))

  override def findTileById(tileId: String): Tile = wrappedRepository.findTileById(tileId)

  override def updateTile(tile: Tile): Tile =
    releaseActorService.executeCommand(releaseIdFrom(tile.getId), UpdateTile(tile))

  override def getSecurityUid(dashboardId: String): Option[String] = wrappedRepository.getSecurityUid(dashboardId)

  override def deleteDashboard(dashboardId: String): Unit = wrappedRepository.deleteDashboard(dashboardId)
}
